---
layout: default
title: Quick reference
---

# Quick reference

Name    | Function         | Description |
------- | ---------------- | ----------- | ----
Orientation | `or` | Rotates the image. | [info](api/orientation/#orientation-or)
Flip | `flip` | Flip the image. | [info](api/orientation/#flip-flip)
Crop | `crop` | Crops the image to specific dimensions. | [info](api/crop/#crop-crop)
Width | `w` | Sets the width of the image, in pixels. | [info](api/size/#width-w)
Height | `h` | Sets the height of the image, in pixels. | [info](api/size//#height-h)
Fit | `fit` | Sets how the image is fitted to its target dimensions. | [info](api/size//#fit-fit)
Device pixel ratio | `dpr` | Multiples the overall image size. | [info](api/pixel-density/#device-pixel-ratio-dpr)
Brightness | `bri` | Adjusts the image brightness. | [info](api/adjustments/#brightness-bri)
Contrast | `con` | Adjusts the image contrast.  | [info](api/adjustments/#contrast-con)
Gamma | `gam` | Adjusts the image gamma.  | [info](api/adjustments/#gamma-gam)
Sharpen | `sharp` | Sharpen the image. | [info](api/adjustments/#sharpen-sharp)
Blur | `blur` | Adds a blur effect to the image.  | [info](api/effects/#blur-blur)
Pixelate | `pixel` | Applies a pixelation effect to the image.  | [info](api/effects/#pixelate-pixel)
Filter | `filt` | Applies a filter effect to the image. | [info](api/effects/#filter-filt)
Watermark Path | `mark` | Adds a watermark to the image. | [info](api/watermarks/#path-mark)
Watermark Width | `markw` | Sets the width of the watermark. | [info](api/watermarks/#width-markw)
Watermark Height | `markh` | Sets the height of the watermark. | [info](api/watermarks/#height-markh)
Watermark X-offset | `markx` | Sets the watermark distance from left/right edges. | [info](api/watermarks/#x-offset-markx)
Watermark Y-offset | `marky` | Sets the watermark distance from top/bottom edges. | [info](api/watermarks/#y-offset-marky)
Watermark Padding | `markpad` | Sets the watermark distance from the edges. | [info](api/watermarks/#padding-markpad)
Watermark Position | `markpos` | Sets where the watermark is positioned.  | [info](api/watermarks/#position-markpos)
Watermark Alpha | `markalpha` | Sets the watermark opacity.  | [info](api/watermarks/#alpha-markalpha)
Background | `bg` | Sets the background color of the image. | [info](api/background/#background-bg)
Border | `border` | Add a border to the image. | [info](api/border/#border-border)
Quality | `q` | Defines the quality of the image. | [info](api/encode/#quality-q)
Format | `fm` | Encodes the image to a specific format. | [info](api/encode/#format-fm)
