<?php
use App\User;
use Spatie\Permission\Models\Role;

class UserTest extends TestCase
{

    public function testGetAgents()
    {
        $seller = User::findByEmail('seller@reco.ma');
        $agents = $seller->getAgentsQuery();
        $this->assertInstanceOf('App\User', $agents->first());
        $this->assertEquals('agent@reco.ma', $agents->first()->email);
        $this->assertGreaterThan(0, $agents->count());
    }

    public function testToArray()
    {
        $seller = User::findByEmail('seller@reco.ma');
        $array = $seller->toArray(true);
        $this->assertArrayHasKey('displayName', $array);
    }

    public function testSendMailYahooToGmail()
    {
    	$this->markTestSkipped('I do not want to get lots of stuff');
		$agent = User::findByEmail('agent@reco.ma');
		//$agent->email = 'denis_raab@yahoo.de';
		$agent->email = 'denis_raab@yahoo.de';

	    $sellerAccount = User::findByEmail('seller@reco.ma')->account;

	    $emailText = 'Hallo';
		$url = 'http://reco.ma/-invalid';

	    $consumer = User::findByEmail('consumer@reco.ma');
	    $consumer->email = 'alex.menk+recotest@gmail.com';

	    Config::set('recoma.no-replyAdress', 'alex.menk+noreply-reco-ma@gmail.com');
	    $consumer->sendMail('agent-sends-coupon-to-new-consumer',
		    compact('sellerAccount', 'emailText', 'url', 'agent'),
	        $agent
	    );

	    // Artisan::call('queue:work'); // not working, why? still mocked?
    }
}