<?php

use App\Shortlink;
use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;

class ShortlinkTest extends TestCase
{
    /**
     * A basic test example.
     *
     * @return void
     */
    public function testInstanceCanBeCreated()
    {
        $shortlink = new Shortlink();
        $this->assertInstanceOf('App\Shortlink', $shortlink);
    }

    public function testShortLinkCanBeCreatedAndFetched()
    {
        $shortlink = Shortlink::createShortlink('http://reco.ma/I-am-very-long');
        $code = $shortlink->shortlink;
        $this->assertGreaterThan(1, strlen($code));
        $this->assertLessThan(10, strlen($code));

        $this->assertTrue(Shortlink::checkIsValid($code));

        $fullLink = $shortlink->getFullShortLink($shortlink);
        $this->assertStringStartsWith('http', $fullLink);
        $this->assertContains($code, $fullLink);
    }
}

