<?php
use App\User;
use Spatie\Permission\Models\Role;

/**
 * @property string sellerEmail
 * @property string password
 * @property string consumerEmailmulti
 * @property string consumerEmailsingle
 */
class ShareLinkTest extends FrontendTestCase
{

    public function testShareRecoma()
    {
        $this->setUpMailMock();

        $this->password = '123-aaa';

        //share-recoma
        $this->login('dev', 'agent@reco.ma');

        $this->visit('/recommend-recoma');

        $link = $this->getWhatsappLink();

        $this->visit('/logout');

        $this->visit($link);

        $this->press('Jetzt empfehlen lassen');
        $this->click('Unternehmen registrieren');


        $this->sellerEmail = $this->faker->email;

        $this->registerRecommendRecoma($this->sellerEmail, $this->password);
        $this->seeMailSent();
        $url = $this->getDoubleOptInUrl();

        $this->visit($url);         //DOI has automated Login
        $this->assertEquals(url('/onboarding-seller'), url()->current()); //FIXME not necessary because of DOI?

        $this->visit('/logout');
        $this->clearMail();

        //share-seller
        $this->login('dev', 'agent@reco.ma');

        $this->visit('/share-seller/2');
        $link = $this->getWhatsappLink();
        $this->visit('/logout');
        $this->visit($link);

        $this->click('Jetzt sparen');

        $this->consumerEmailmulti = $this->faker->email;
        $this->registerUser($this->consumerEmailmulti, $this->password);

        $user = User::withoutGlobalScopes()->where('email', '=', $this->consumerEmailmulti)->first();

        $url = url('/activate/'. $user->id . '/' . $user->email_verification_token);

        $this->visit($url); //DOI has automated Login
        $this->assertEquals(url('/dashboard/consumer'), url()->current());
        $this->visit('/logout');
        $this->clearMail();

        //share-coupon
        $this->login('dev', 'agent@reco.ma');

        $this->visit('/share-coupon/2');
        $link = $this->getWhatsappLink();
        $this->visit('/logout');
        $this->visit($link);

        $this->click('Jetzt sparen');

        $this->consumerEmailsingle = $this->faker->email;
        $this->registerUser($this->consumerEmailsingle, $this->password);

        $user = User::withoutGlobalScopes()->where('email', '=', $this->consumerEmailsingle)->first();

        $url = url('/activate/'. $user->id . '/' . $user->email_verification_token);

        $this->visit($url); //DOI has automated Login
        $this->assertEquals(url('/dashboard/consumer'), url()->current());
        $this->visit('/logout');
        $this->clearMail();
    }

    /**
     * Register for Seller-Landingpage
     * @param $email
     * @param $password
     */
    public function registerRecommendRecoma($email, $password)
    {
        $this->type($this->faker->firstName, 'firstname');
        $this->type($this->faker->lastName, 'surname');
        $this->type($company = $this->faker->company, 'company');
        $this->type($email, 'email');

        $this->type($password, 'password');
        $this->type($password, 'password_confirmation');

        $this->type('10178', 'zip');
        $this->press('Jetzt Registrieren');
    }

    public function registerUser($email, $password)
    {
        $this->type($this->faker->firstName, 'firstname');
        $this->type($this->faker->lastName, 'surname');
        $this->type($email, 'email');
        $this->type('65343', 'zip');
        $this->type($password, 'password');
        $this->type($password, 'password_confirmation');
        $this->press('Speichern');
    }
}