<?php

use App\Services\SellerRegistrationService;
use Illuminate\Foundation\Testing\DatabaseTransactions;

class SellerRegistrationServiceTest extends TestCase
{
    use DatabaseTransactions;

    public function testRegister()
    {

        $this->dontSeeInDatabase('users', ['email' => 'fake@example.com']);
        $data = ['token' => '-1',
            'firstname' => 'Dude',
            'surname' => 'Dudeman',
            'company' => 'Dudes Company',
            'email' => 'fake@example.com',
            'password' => '123456789',
            'password_confirmation' => '123456789',
            'zip' => '12345',
        ];
        $registrationService = new SellerRegistrationService($data);

        $user = $registrationService->register();
        $this->seeInDatabase('users', ['email' => 'fake@example.com']);
        $this->assertNotEmpty($registrationService->getAccount()->id);

        $registrationService->sendDoubleOptInMail($user);
    }
}