<?php

class SellerFrontendTest extends FrontendTestCase
{

    public function testCanVisitDashboardAsSeller()
    {
        $this->loginSeller();

        $this->visit('/dashboard/seller');
    }

    public function testCanEditUserProfileAsSeller()
    {
        $this->loginSeller();
        $this->editUserProfile();
    }

    public function testAgentsListAsSellerIsDisplayed()
    {
        $this->loginSeller();
        $this->visit('/agent');
    }

    public function testShowCouponTemplatesAsSeller()
    {
        $this->loginSeller();
        $this->visit('/coupon');
    }

    public function testCreateCouponTemplatesAsSeller()
    {
        $this->loginSeller();
        $this->visit('/coupon/edit');

        $title = $this->faker->country;
        $expirationDate = $this->faker->date();
        $description = $this->faker->text();
        $consumerDiscount = $this->faker->randomDigit;
        $agentProvision = $this->faker->randomDigit;
        $quota = $this->faker->randomElement(['100', '150', '200', '250', '300']);

        $this->within('#couponCreateOrEdit', function ()
        use ($title, $expirationDate, $description, $consumerDiscount, $agentProvision, $quota) {
            $this->type($title, 'title');
            $this->type($expirationDate, 'expiration_date');
            $this->type($description, 'description');
            $this->type($consumerDiscount, 'discount_consumer');
            $this->type($agentProvision, 'provision_agent');
            $this->type($quota, 'quota');

            $this->press('Erstellen');
        });
    }

    public function testShowMockCouponRedeemAsSeller()
    {
        $this->loginSeller();

        $couponTemplate = \App\CouponTemplate::all()->first();
        $consumer = \App\User::findByEmail('consumer@reco.ma');
        $agent = \App\User::findByEmail('agent@reco.ma');
        $data = [
            'coupon_template_id' => $couponTemplate->id,
            'consumer_user_id' => $consumer->id,
            'agent_user_id' => $agent->id,
            'title' => $couponTemplate->title,
            'expiration_date' => $couponTemplate->expiration_date,
            'description' => $couponTemplate->description,
            'provision_agent' => $couponTemplate->provision_agent,
            'discount_consumer' => $couponTemplate->discount_consumer,
            'status' => 'active',
            'code' => $this->generateCode(),
            'netto' => '0.00'
        ];

        $coupon = \App\Coupon::create($data);
        $this->visit('/coupon/redeem');

        $this->within('#redeemCoupon', function() use($coupon){
           $this->type($coupon['code'], 'coupon_code');
           $this->type($this->faker->randomDigit, 'net_amount');
           $this->press('Einlösen');
        });
    }

    protected function generateCode($length = 15)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        $codes = DB::table('coupons')->select('code')->get();
        if (in_array($randomString, $codes)) {
            $this->generateCode();
        }

        return $randomString;
    }

    public function testShowTransactionAsSeller()
    {
        $this->loginSeller();
        $this->visit('/transaction');
    }

    public function testShowInvitationAsSeller()
    {
        $this->loginSeller();
        $this->visit('/invitation');
    }

    public function testShowRatingAsSeller()
    {
        $this->loginSeller();
        $this->visit('/user/rating');
    }

    public function testShowAccountProfileAsSeller()
    {
        $this->loginSeller();
        $this->visit('/account');
    }

    public function testShowMembersAsSeller()
    {
        $this->loginSeller();
        $this->visit('/member');
    }
}