<?php


/**
 * @property string password
 * @property string sellerEmail
 * @property string invitedUser
 * @property  recentMailData
 * @property string agentEmail
 * @property string devPasswort
 */
class RecommendRecomaTest extends FrontendTestCase
{

    public function testRecommendRecoma()
    {
        $this->setUpMailMock();

        $this->devPasswort = 'dev';
        $this->password = 'dev-123';

        //use standart user for recommendation
        $this->sellerEmail = 'seller@reco.ma';
        $this->agentEmail = 'agent@reco.ma';
        $this->invitedUser = $this->faker->email;

        //Seller recommends recoma
        //Seller
        $this->login($this->devPasswort, $this->sellerEmail);
        $this->visit('/create-link/recommend-recoma/email');
        $this->select('Herr', 'salutation');
        $this->type($this->faker->firstName, 'firstname');
        $this->type($this->faker->lastName, 'surname');
        $this->type($this->invitedUser, 'email');

        $this->clearMail();
        $this->press('Empfehlen');
        $this->seeMailSent();
        $this->assertArrayHasKey('url', $this->recentMailData);
        $url = $this->recentMailData['url'];

        $this->visit('/logout');

        //register invited seller
        $this->visit($url);

        $this->press('Jetzt empfehlen lassen');
        $this->click('Unternehmen registrieren');

        $this->type($this->faker->firstName, 'firstname');
        $this->type($this->faker->lastName, 'surname');
        $this->type($company = $this->faker->company, 'company');

        $this->type($email = $this->invitedUser, 'email');
        $this->type($password = $this->faker->password, 'password');
        $this->type($password , 'password_confirmation');

        $this->type('10178', 'zip');

        $this->press('Jetzt Registrieren');

        // Link anklicken
        $this->seeMailSent();
        $this->assertArrayHasKey('url', $this->recentMailData);
        $url = $this->recentMailData['url'];
        $this->visit($url);


        $this->stepIntoSellerOverlay();

        $this->see('Abmelden'); // check if log in worked
        $this->visit('/logout');

        //FIXME ggf. Obsolet, muss nach #24816 gefixt werden
        $recommendingAccount = App\User::findByEmail($this->sellerEmail)->account;
        $invitedAccount = App\User::findByEmail($this->invitedUser)->account;

        $recommendFreeMonthTransaction = \App\Transaction::where('type', '=', 'seller-free-monthly-payment')
            ->where('billed_until', '=', $recommendingAccount->billed_until)
            ->first();

        $invitedFreeMonthTransaction = \App\Transaction::where('type', '=', 'seller-free-monthly-payment')
            ->where('billed_until', '=', $invitedAccount->billed_until)
            ->first();

        if(!isset($recommendFreeMonthTransaction)){
            $this->assertNotEmpty($recommendFreeMonthTransaction);
        }
        if(!isset($invitedFreeMonthTransaction)){
            $this->assertNotEmpty($invitedFreeMonthTransaction);
        }

        $this->invitedUser = $this->faker->email;

        //Agent recommends recoma
        $this->login($this->devPasswort, $this->agentEmail);
        $this->visit('/create-link/recommend-recoma/email');
        $this->select('Herr', 'salutation');
        $this->type($this->faker->firstName, 'firstname');
        $this->type($this->faker->lastName, 'surname');
        $this->type($this->invitedUser, 'email');

        $this->clearMail();
        $this->press('Empfehlen');
        $this->seeMailSent();
        $this->assertArrayHasKey('url', $this->recentMailData);
        $url = $this->recentMailData['url'];

        $this->visit('/logout');

        //set password for invited seller
        $this->visit($url);
        $this->press('Jetzt empfehlen lassen');
        $this->click('Unternehmen registrieren');

        $this->type($this->faker->firstName, 'firstname');
        $this->type($this->faker->lastName, 'surname');
        $this->type($company = $this->faker->company, 'company');

        $this->type($this->invitedUser, 'email');
        $this->type($this->password, 'password');
        $this->type($this->password, 'password_confirmation');

        $this->type('10178', 'zip');

        $this->press('Jetzt Registrieren');
    }

}



