<?php

use Illuminate\Foundation\Testing\Constraints\HasSource;
use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use \App\User;

class GlobalScopeTest extends TestCase
{
    /**
     * A basic test example.
     *
     * @return void
     */

    const RELATED_AGENT_ACCOUNTS = 1;

    public function testGlobalScope()
    {
//        $this->markTestSkipped('Bla');
        $sellerUser = USER::findByEmail('seller@reco.ma');
        $sellerName = $sellerUser->account->getDisplayName();
        $agentUser = USER::findByEmail('agent@reco.ma');
        $agentName = $agentUser->getDisplayName();
        $consumerUser = USER::findByEmail('consumer@reco.ma');
        $consumerName = $consumerUser->getDisplayName();

        $relatedAgentAccountsToSeller = $sellerUser->account->relatedAgentAccounts()->count();

        //disable seller@reco.ma
        $this->disableUser('seller@reco.ma');
        $this->disableUser('consumer@reco.ma');


        //login as Agent   seller is hidden, consumer is hidden
        $this->loginAs('agent');
        $this->dontSee( $sellerName);
        $this->visit('/sellers');
        $this->dontSee( $sellerName);
        $this->visit('/coupon');
        $this->dontSee( $sellerName);
        $this->visit('/coupon/redeem');
        $this->dontSee( $sellerName);
        $this->dontSee($consumerName);
        $this->see(trans('translations.not-active'));
        $this->visit('/invitation');
        $this->dontSee( $sellerName);
        $this->visit('/transaction');
        $this->dontSee( $sellerName);
        $this->dontSee($consumerName);
        $this->logout();

        //enable seller
        $this->enableUser('seller@reco.ma');

        //login as seller, consumer is hidden, agent is visible
        $this->loginAs('seller');
        $this->dontSee($consumerName);
        $this->visit('/coupon/redeem');
        $this->dontSee($consumerName);
        $this->see(trans('translations.not-active'));
        $this->see('Transaktion nicht möglich');

        $this->tryToRedeemCoupon();

        $this->visit('/transaction');
        $this->dontSee($consumerName);
        $this->see(trans('translations.not-active'));

        $this->visit('/user/rating');
        $this->dontSee($consumerName);
        $this->see(trans('translations.not-active'));

        $this->assertCount($relatedAgentAccountsToSeller,$sellerUser->account->relatedAgentAccounts()->get());
        $this->logout();

        //enable Consumer and disable agent
        $this->enableUser('consumer@reco.ma');
        $this->disableUser('agent@reco.ma');


        //login as seller to see changes, agent is hidden, consumer is visible
        $this->loginAs('seller');
        $this->dontSee($agentName);
        $this->visit('/agent');
        $this->dontSee($agentName);
        $this->assertCount($relatedAgentAccountsToSeller-1,$sellerUser->account->relatedAgentAccounts()->get());
        $this->visit('/coupon/redeem');
        $this->dontSee($agentName);
        $this->see(trans('translations.not-active'));
        $this->see('Transaktion nicht möglich');
        $this->tryToRedeemCoupon();

        $this->visit('/transaction');
        $this->dontSee($agentName);
        $this->see(trans('translations.not-active'));
        $this->logout();

        //Seller sollte eigentlich aktiv sein
        $this->enableUser('seller@reco.ma');
        //login as consumer,agent is hidden, seller is visible
        $this->loginAs('consumer');
        $this->see($sellerName);
        $this->dontSee($agentName);
        $this->visit('/transaction');
        $this->dontSee($agentName);
        $this->logout();

        //enable agent, disable seller
        $this->enableUser('agent@reco.ma');
        $this->disableUser('seller@reco.ma');


        //login as consumer, seller is hidden, agent is visible
        $this->loginAs('consumer');
        $this->see($agentName);
        $this->dontSee($sellerName);
        $this->see(trans('translations.not-active'));
        $this->visit('/transaction');
        $this->dontSee($sellerName);
        $this->see($agentName);
        $this->see(trans('translations.not-active'));
        $this->logout();

        //disable agent
        $this->disableUser('agent@reco.ma');


        //login as consumer, seller is hidden, agent is visible
        $this->loginAs('consumer');
        $this->dontSee($agentName);
        $this->dontSee($sellerName);
        $this->see(trans('translations.not-active'));
        $this->visit('/transaction');
        $this->dontSee($sellerName);
        $this->dontSee($agentName);
        $this->see(trans('translations.not-active'));
        $this->logout();

        //enable agent
        $this->enableUser('agent@reco.ma');


        //login as Agent   seller is hidden, consumer is visible
        $this->loginAs('agent');
        $this->dontSee($sellerName);
        $this->visit('/sellers');
        $this->dontSee($sellerName);
        $this->visit('/coupon');
        $this->dontSee($sellerName);
        $this->visit('/coupon/redeem');
        $this->dontSee($sellerName);
        $this->see($consumerName);
        $this->see(trans('translations.not-active'));
        $this->visit('/invitation');
        $this->dontSee($sellerName);
        $this->visit('/transaction');
        $this->dontSee($sellerName);
        $this->see($consumerName);
        $this->logout();

        //enable seller,
        $this->enableUser('agent@reco.ma');
        $this->enableUser('seller@reco.ma');


        //login as Agent   seller is visible, consumer is visible
        $this->loginAs('agent');
        $this->see($sellerName);
        $this->visit('/sellers');
        $this->see($sellerName);
        $this->visit('/coupon');
        $this->see($sellerName);
        $this->visit('/coupon/redeem');
        $this->see($sellerName);
        $this->see($consumerName);
        $this->dontSee(trans('translations.not-active'));
        $this->visit('/invitation');
        $this->see($sellerName);
        $this->visit('/transaction');
        $this->see($sellerName);
        $this->see($consumerName);
        $this->logout();


        //disable consumer and disable agent
        $this->disableUser('consumer@reco.ma');
        $this->disableUser('agent@reco.ma');


        //login as seller, agent is hidden, consumer is hidden
        $this->loginAs('seller');
        $this->dontSee($agentName);
        $this->visit('/agent');
        $this->dontSee($agentName);
        $this->assertCount($relatedAgentAccountsToSeller-1,$sellerUser->account->relatedAgentAccounts()->get());
        $this->visit('/coupon/redeem');
        $this->dontSee($agentName);
        $this->see(trans('translations.not-active'));
        $this->see('Transaktion nicht möglich');
        $this->tryToRedeemCoupon();
        $this->visit('/transaction');
        $this->dontSee($agentName);
        $this->see(trans('translations.not-active'));
        $this->logout();

        //enable consumer and enable agent
        $this->enableUser('consumer@reco.ma');
        $this->enableUser('agent@reco.ma');

        //login as seller, agent is visible, consumer is visible
        $this->loginAs('seller');
        $this->see($agentName);
        $this->visit('/agent');
        $this->see('Agent Company Ltd.');
        $this->assertCount($relatedAgentAccountsToSeller,$sellerUser->account->relatedAgentAccounts()->get());
        $this->visit('/coupon/redeem');
        $this->see($agentName);
        $this->dontSee(trans('translations.not-active'));
        $this->dontSee('Transaktion nicht möglich');
//        $this->tryToRedeemCoupon('success');
        $this->visit('/transaction');
        $this->see($agentName);
        $this->dontSee(trans('translations.not-active'));
        $this->logout();



        //login as consumer, seller is visible, agent is visible
        $this->loginAs('consumer');
        $this->see($agentName);
        $this->see($sellerName);
        $this->dontSee(trans('translations.not-active'));
        $this->visit('/transaction');
        $this->see($sellerName);
        $this->see($agentName);
        $this->dontSee(trans('translations.not-active'));
        $this->logout();

        //enable consumer and enable agent
        $this->enableUser('consumer@reco.ma');
        $this->enableUser('agent@reco.ma');
        $this->enableUser('seller@reco.ma');

    }



    protected function loginAs($type)
    {
        $this->visit('/login');
        $this->type($type . '@reco.ma', 'email');
        $this->type('dev', 'password');
        $this->press('Anmelden');
        $this->assertNotContains(
            'login', $this->currentUri, "Login did not work."
        );
    }

    protected function tryToRedeemCoupon($expectedResult = 'error'){
        $coupon = \App\Coupon::where('code','A80JDSUW9')->first();
        $this->within('#redeemCoupon', function() use($coupon,$expectedResult){
            $this->type($coupon->code, 'coupon_code');
            $this->type($this->faker->randomDigit, 'net_amount');
            $this->press('Einlösen');
        });
        if($expectedResult == 'success'){
            $this->assertToastrSuccess();
        }else{
            $this->assertToastrError();
        }

    }

    protected function disableUser($userEmail){
        $this->loginAs('operator');
        $this->changeStatusUser($userEmail,User::STATUS_DISABLED);
        $this->assertToastrSuccess();
        $this->logout();
    }

    protected function enableUser($userEmail){
        $this->loginAs('operator');
        $this->changeStatusUser($userEmail,User::STATUS_ACTIVE);
        $this->assertToastrSuccess();
        $this->logout();
    }

    protected function changeStatusUser($userEmail,$status){
        $userId = User::findByEmail($userEmail)->id;
        $this->visit('/user/edit/'.$userId);
        $this->see($userEmail);

        $this->within('#userEditForm', function ()use ($status){
            $this->select($status, 'status');
            $this->press('Speichern');
        });
    }

    protected function assertToastrSuccess()
    {
        $this->assertToastrType('success', 'Failed asserting Toastr success.');
    }

    protected function assertToastrError()
    {
        $this->assertToastrType('error', 'Failed asserting Toastr error.');
    }

    protected function assertToastrType($type, $message) {
        $this->assertInPage(new HasSource("toastr['$type']"), false, $message);
    }
    protected function logout(){
        $this->visit('/logout');
    }
}
