<?php

use Illuminate\Foundation\Testing\Constraints\HasSource;

class FrontendTestCase extends TestCase
{
    /**
     * Assert toastr feedback type (toastr is the small message popup, initialized via a javascript snipped)
     * @param $type
     * @param $message
     */
    protected function assertToastrType($type, $message) {
        $this->assertInPage(new HasSource("toastr['$type']"), false, $message);
    }
    protected function assertToastrSuccess()
    {
        $this->assertToastrType('success', 'Failed asserting Toastr success.');
    }

    protected function assertToastrError()
    {
        $this->assertToastrType('error', 'Failed asserting Toastr error.');
    }

    protected function loginAs($type)
    {
        $this->visit('/login');
        $this->type($type . '@reco.ma', 'email');
        $this->type('dev', 'password');
        $this->press('Anmelden');
        $this->assertNotContains(
            'login', $this->currentUri, "Login did not work."
        );
    }

    protected function loginOperator()
    {
        $this->loginAs('operator');
    }

    protected function loginAgent()
    {
        $this->loginAs('agent');
    }

    protected function loginSeller()
    {
        $this->loginAs('seller');
    }

    protected function loginConsumer()
    {
        $this->loginAs('consumer');
    }

    protected function loginFieldservice()
    {
        $this->loginAs('fieldservice_employee');
    }

    protected function editUserProfile()
    {
        $this->visit('/user/profile');
        $firstName = $this->faker->firstname;
        $lastname = $this->faker->lastname;

        $this->within('#userEditForm', function () use ($firstName, $lastname) {
            $this->type($firstName, 'firstname');
            $this->type($lastname, 'surname');
            $this->press('Speichern');
            // FIXME: check in db if saved
        });
    }

    /*
    * return DOI-Url provided in Mail
    */
    protected function getDoubleOptInUrl()
    {
        $this->seeMailSent();
        return '/activate/' . $this->recentMailData['toUserArray']['account_id'] . '/' . $this->recentMailData['toUserArray']['email_verification_token'];
    }

    /**
     * fill missing Fields in Sellerprofile
     * @param string $payment
     */
    public function fillSellerProfile($payment = 'month')
    {
        $this->seePageIs('/user/profile');
        $this->type('DE123456789', 'tax_id');
        $this->type($this->faker->streetName, 'street');
        $this->type($this->faker->randomDigit, 'housenumber');

        $this->type($this->faker->city, 'city');
        $this->type('0123456789', 'phone');
        $this->select('1', 'all_connections');
        $this->select($payment, 'payment');
        $this->type($this->faker->name, 'iban_owner');
        $this->type('DE12500105170648489890', 'iban');
//        $this->check('agb');
//        $this->check('sepa'); //FIXME has to be added?

        $this->press('Speichern');

        //refresh user to load new status & roles
        $this->be(Auth::user()->fresh());
    }

    public function stepIntoSellerOverlay()
    {
        $this->click("Los geht's!");
        $this->press('Empfehler einladen');
        $this->click('überspringen');

        $this->type($this->faker->streetName, 'street');
        $this->type($this->faker->randomNumber(), 'housenumber');
        $this->type('65343', 'zip');
        $this->type($this->faker->city, 'city');
        $this->type('02123456789', 'phone');
        $this->select(0, 'all_connections');
        $this->check('newsletter');

        $this->press('Unternehmen anlegen');

        $this->select('year', 'payment');
        $this->type($this->faker->name, 'iban_owner');
        $this->type($this->faker->iban('DE', null, 20), 'iban');
        $this->check('sepa');
        $this->check('data-protection-agb');

        $this->press('Unternehmen anlegen');
        $this->click('Zum Dashboard');
    }

    public function skipAgentOverlay()
    {
        $this->click("Los geht's!");
        $this->press("weiter");
        $this->click("weiter");
        $this->click("Zum Dashboard");
    }

    public function getWhatsappLink()
    {
        $link = $this->crawler()->selectLink('Whatsapp');
        $uri = $link->link()->getUri();

        $this->makeRequestWithoutFollowingRedirect('GET',$uri);

        preg_match('@http://([a-zA-z0-9-._+])+/-[a-zA-Z0-9]+@', urldecode($this->response->getTargetUrl()), $registrationLink);
        return $registrationLink[0];
    }

    public function checkReceivedSellerStatus($email){
        $user = \App\User::where('email', '=',  $email)->first();
        $account = $user->account;
        $today = \Carbon\Carbon::today();
        $this->assertTrue($today->isSameDay($account->received_seller_role_at));
    }
}