<?php

class FrontendTest extends FrontendTestCase
{
    public function testCanVisitDashboardAsAgent()
    {
        $this->loginAgent();

        $this->visit('/dashboard/agent');
    }

    public function testCanVisitDashboardAsSeller()
    {
        $this->loginSeller();

        $this->visit('/dashboard/seller');
    }

    public function testCanEditUserProfileAsOperator()
    {
        $this->loginOperator();
        $this->editUserProfile();
    }

    public function testCanEditUserProfileAsSeller()
    {
        $this->loginSeller();
        $this->editUserProfile();
    }

    public function testCanEditUserProfileAsAgent()
    {
        $this->loginAgent();
        $this->editUserProfile();
    }

    public function testEditUserProfileAsConsumer()
    {
        $this->loginConsumer();
        $this->editUserProfile();
    }

    public function testAgentsListAsSellerIsDisplayed()
    {
        $this->loginSeller();
        $this->visit('/agent');
    }

}