<?php

use App\BankTransaction;
use App\Transaction;
use Illuminate\Foundation\Testing\Constraints\HasSource;

class FieldserviceFrontendTest extends FrontendTestCase
{
    public function testCanCreateNewSeller()
    {
        $this->setUpMailMock();

        $this->loginFieldservice();
        $this->visit('/user/create-recruited');

        // FIXME: weitere felder ausfüllen

        $this->type($this->faker->firstName, 'firstname');
        $this->type($this->faker->lastName, 'surname');
        $this->type($company = $this->faker->company, 'company');
        $this->type('12345', 'zip');
        $this->type('Teststadt', 'city');
        $this->type('Teststraße', 'street');
        $this->type('123', 'housenumber');
        $this->type($email = $this->faker->email, 'email');
        $this->type('021234567', 'phone');
        $this->select('year', 'payment');
        $this->type('DE17570928000217117500', 'iban');
        $this->type('Testinhaber', 'iban_owner');
        $this->type('DE123456789', 'tax_id');
        $this->select(1, 'all_connections');

        $this->clearMail();

        $this->press('Speichern');
        $this->assertToastrSuccess();

        $this->visit($this->getDoubleOptInUrl());

        $this->seeInDatabase('accounts', ['company' => $company]);
        $this->seeInDatabase('users', ['email' => $email]);

//        $createdAccount = App\User::whereEmail($email)->first()->account;
//
//        /*Es gibt noch keine Transaktion für den ADM*/
//        $recommendersLastTransaction = App\User::findByEmail('fieldservice_employee@reco.ma')
//            ->transactions()
//            ->where('recruited_account_id', '=', $createdAccount->id)
//            ->get()
//            ->last();
//
//        switch($createdAccount ->payment) {
//            case 'month':
//                $amount = config('recoma.fix-provision');
//                break;
//            case 'year':
//                $amount = config('recoma.fix-provision');
//                break;
//        }
//
//        $this->assertEquals(number_format($amount, 2), $recommendersLastTransaction->amount);
//
//        Artisan::call('seller:create-invoices');
//
//        /**
//         * @var $feeTransaction \App\Transaction
//         */
//        $feeTransaction = $createdAccount->users->first()->transactions()->whereIn('type', \App\Transaction::TYPE_FEE)->first();
//
//        $this->assertNotNull($feeTransaction, "Seller Invoice was not created");
//        BankTransaction::createFakeFromReceipt($feeTransaction->getReceipt(), true);
//
//
//        Transaction::releaseAllEligible(true);

    }


}