<?php

use App\Library\Billomat\BillomatClientHelper;

class BillomatClientHelperTest extends TestCase {

    /**
     * Check if permissions are right for different user-mode
     * i.e. development with testcases and web access
     */
    public function testFilesAreCreatedProperly()
    {
        $diskPath = storage_path('app/public/creditnote/pdf/test.pdf');
        @unlink($diskPath);
        $this->assertFileNotExists($diskPath);

        $pdf_path = 'test.pdf';
        $pdf_response = new \Guzzle\Http\Message\Response(200);

        BillomatClientHelper::storePDF('creditnotepdf', $pdf_path, $pdf_response );

        $result = shell_exec('getfacl ' . escapeshellarg($diskPath));

        $this->assertContains('#effective:rw', $result);
    }


	public function testResolveArticles()
	{
		foreach(config('billomat.articles') as $type=>$number) {
			$id = BillomatClientHelper::resolveArticle($number);
			$this->assertInternalType('integer', $id);
			$this->assertGreaterThan(0, $id);
		}
	}
}