<?php


use App\BankTransaction;

class BankTransactionTest extends TestCase {
    public function setUp()
    {
        parent::setUp();
//        $this->markTestSkipped('Enable me if you want to test with AqBanking');
    }

    public function testGetBalance()
    {
        $balance = BankTransaction::getBalance();
        $this->assertContains('EUR', $balance);
    }

    public function testGetTransactions()
    {
        $transactions = BankTransaction::getTransactions();
        $this->assertGreaterThan(1, count($transactions));
    }

    /**
     * This test might have to be changed over time, when the first transactions don't come in anymore
     */
    public function testGetKeyedTransactions()
    {
        $this->markTestSkipped();
        $expectedKey = '2016092000001';
        $keyedTransactions = BankTransaction::getKeyedTransactions();
        $this->assertArrayHasKey($expectedKey, $keyedTransactions);
        $this->assertInstanceOf(\AqBanking\Transaction::class, $keyedTransactions[$expectedKey]);

        $expectedCount = count(BankTransaction::getTransactions());
        $this->assertCount($expectedCount, $keyedTransactions);
    }

    public function testImportTransactions()
    {
        $this->markTestSkipped();
        BankTransaction::importTransactions();
    }

    public function testBookedBackTransactions()
    {
        $seller = \App\User::where('email', '=', 'seller@reco.ma')->first();
        $i = 1;
        do{
            $u = 0;
            $number = 'RE' . $i;
            $invoice = \App\Invoice::where('number', '=', $number)->first();
            if(!isset($invoice)){
                $u = $i;
            }else{
                $i++;
            }
        }while($u == 0);

        $invoice = new \App\Invoice();
        $data = [
            'coupon_id' => 1,
            'billomat_id' => null,
            'pdf_path' => null,
            'status' => 'OPEN',
            'type' => 'invoice',
            'user_id' => $seller->id,
            'gross_amount' => 0.55,
            'number' => $number,
        ];
        $invoice->fill($data);
        $invoice->save();

        BankTransaction::createFakeFromReceipt($invoice, true, 'Retoure SEPA Lastschrift');
        $invoice = $invoice->fresh();

        $this->assertEquals(\App\AbstractReceipt::STATUS_BOOKED_BACK, $invoice->status);
    }
}