<?php

class AgentFrontendTest extends FrontendTestCase
{
    public function testCanVisitDashboardAsAgent()
    {
        $this->loginAgent();

        $this->visit('/dashboard/agent');
    }

    public function testDashboardValuesAreCorrect()
    {
        $this->markTestSkipped('Not finished / values to be reconsidered');
        $this->loginAgent();

        $this->visit('/dashboard/agent');

        $this->within('#paidOutProvision', function() {
           $this->see('0 €');
        });
        $this->within('#openProvision', function() {
           $this->see('5 €');
        });
        $this->within('#couponsFinishedCount', function() {
           $this->see('1');
        });
        $this->within('#averageConversionRate', function() {
            $this->see('25 %');
        });
        $this->within('#sharedCoupons', function() {
            $this->see('4');
        });
        $this->within('#averageProvision', function() {
            $this->see('0');
        });
        $this->within('#conversionRate', function() {
            $this->see('0 %');
        });
        $this->within('#provsion', function() {
            $this->see('0 €');
        });
    }
    public function testCanEditUserProfileAsAgent()
    {
        $this->loginAgent();
        $this->editUserProfile();
    }

    public function testSellersListAsAgentIsDisplayed()
    {
        $this->loginAgent();
        $this->visit('/sellers');
    }

    public function testCanSendSelectionCoupon()
    {
        $this->visit('/logout');
        $this->loginAgent();
        $this->visit('/create-link/share-coupon/email/3"');

        $this->type('Consumer', 'firstname');
        $this->type('John', 'surname');
        $this->type('consumer@reco.ma', 'email');
        $this->press('Senden');
        $this->seePageIs('/coupon/redeem');
    }

}