<?php
use App\Account;
use Carbon\Carbon;

class AccountTest extends TestCase
{
    protected $realToday;

    public function testGetAllSellers()
    {
        $this->assertNotEmpty(Account::allSellerAccounts());
    }

    public function testSendMailToUsers()
    {
        $account = Account::first();
        Auth::login($account->users()->first());
        $account->sendMailToUsers('agent-invite', ['sellerAccount' => $account, 'url' => 'http://example.com']);
    }

    public function testCreateMembershipInvoice()
    {
        $account = Account::allSellerAccounts()->first();

        $invoice = $account->createMembershipInvoice();

        $this->assertInstanceOf('App\Invoice', $invoice);
    }

    public function assertDateEquals($expected, $actual, $message = '')
    {
        $this->assertEquals($expected, $actual, 'Date ' . $actual . ' should be ' . $expected . ' '  . $message);
    }

    public function testSellerCreateInvoicesWithDifferentDates()
    {
        $email = $this->faker->email;
        $this->registrationService('seller', $email, 'year');
        $yearlyBilledAccount = App\User::findByEmail($email)->account;
        $email = $this->faker->email;
        $this->registrationService('seller', $email, 'month');
        $monthlyBilledAccount = App\User::findByEmail($email)->account;

        $inAMonth = Carbon::today()->addMonth();
        $in2Months = Carbon::today()->addMonth()->addMonth();
        $in15Days = Carbon::today()->addDays(15);
        $inAYear = Carbon::today()->addYear();
        $inAYearAndAMonth = Carbon::today()->addYear()->addMonth();
        $in2YearsAndAMonth = Carbon::today()->addYear(2)->addMonth();

        //date must be in one year/month + free month
        // from today
        Artisan::call('seller:create-invoices');
        $yearlyBilledAccount = $yearlyBilledAccount->fresh();
        $monthlyBilledAccount = $monthlyBilledAccount->fresh();
        $this->assertDateEquals($inAYearAndAMonth, $yearlyBilledAccount->billed_until);
        $this->assertDateEquals($in2Months, $monthlyBilledAccount->billed_until);

        //Test with today in a 15 days
        \Carbon\Carbon::setTestNow($in15Days);
        Artisan::call('seller:create-invoices');
        $yearlyBilledAccount = $yearlyBilledAccount->fresh();
        $monthlyBilledAccount = $monthlyBilledAccount->fresh();
        $this->assertDateEquals($inAYearAndAMonth, $yearlyBilledAccount->billed_until);
        $this->assertDateEquals($in2Months, $monthlyBilledAccount->billed_until);

        //Test with today in a month, simulate that the cron did not run for two days
        $inAMonthAnd2Days = $inAMonth->addDay(2);
        \Carbon\Carbon::setTestNow($inAMonthAnd2Days );
        Artisan::call('seller:create-invoices');
        $yearlyBilledAccount = $yearlyBilledAccount->fresh();
        $monthlyBilledAccount = $monthlyBilledAccount->fresh();
        $this->assertDateEquals($inAYearAndAMonth, $yearlyBilledAccount->billed_until);
        $this->assertDateEquals($in2Months, $monthlyBilledAccount->billed_until);

        //Test with today in a year
        \Carbon\Carbon::setTestNow($inAYear);
        Artisan::call('seller:create-invoices');
        $yearlyBilledAccount = $yearlyBilledAccount->fresh();
        $monthlyBilledAccount = $monthlyBilledAccount->fresh();
        $this->assertDateEquals($inAYearAndAMonth, $yearlyBilledAccount->billed_until);

        // undefined what should happen to the monthly... we do not make multiple bills per iteration ! billing has to run at least once per month
    }
}