<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

//Route::group(['domain' => env('SITE_URL', 'reco.ma')], function () {

    Route::post('/register', 'AuthController@register');

    Route::auth();

    Route::get('/register/thank-you', ['as' => 'register-thank-you', 'uses' => 'IndexController@thankYou']);


    Route::post('/login', 'Auth\AuthController@loginHandler');

    Route::get('login/{invitationToken}', ['as' => 'auth.login', 'uses' => 'Auth\AuthController@showLoginForm']);

    Route::get('/portraits/{name}', ['as' => 'user-portrait', 'uses' => 'UserController@getImage']);
    Route::get('/account/portraits/{name}', ['as' => 'account-portrait', 'uses' => 'ImageController@getImage']);

    Route::post('/handleEasyRegistration', ['as' => 'handle-easy-registration', 'uses' => 'Auth\AuthController@handleEasyRegistrationType']);
    Route::get('/auth/facebook/callback', 'Auth\AuthController@handleProviderCallback');

    Route::get('/share-via-desktop/{token}/{type}', 'CouponTemplateController@shareViaDesktop');
    Route::get('/create-link/{reason}/{type}/{id?}', ['as' => 'linkinvitation', 'uses' => 'Controller@link']);
    Route::get('/create-link/massinvitation', ['middleware' => ['canAny:recommend recoma'], 'as' => 'massinvitation', 'uses' => 'MassInvitationController@index']);
    Route::post('/massinvitation', ['middleware' => ['canAny:recommend recoma'], 'as' => 'massinvitation-post', 'uses' => 'MassInvitationController@create']);
    Route::post('/massinvitation/upload', ['middleware' => ['canAny:recommend recoma'], 'as' => 'massinvitation-upload', 'uses' => 'MassInvitationController@upload']);

    Route::get('/', ['as' => 'home', 'uses' => 'HomeController@index']);

    Route::group(['middleware'=>'onBoardingIncomplete'],function (){

    Route::get('/public/profile/{id}', 'UserController@publicProfile');

    Route::get('/dashboard/operator', ['middleware' => ['canAny:show operator dashboard'], 'uses' => 'DashboardController@operator']);
    Route::post('/dashboard/operator', ['middleware' => ['canAny:show operator dashboard'], 'uses' => 'DashboardController@operator']);

    // User & Accounts
    Route::model('user', 'App\User');
    Route::model('account', 'App\Account');
    Route::get('/user', [ 'middleware' => ['canAny:show users,show recruited users'], 'as' => 'user', 'uses' => 'UserController@index']);
    Route::get('/user/edit', ['uses' => 'UserController@edit']);
    Route::post('/user/edit', ['uses' => 'UserController@store']);
    Route::get('/user/edit/{id}', ['as' => 'user-edit-id', 'uses' => 'UserController@edit']);
    Route::post('/user/edit/{id}', ['as' => 'user-edit-id-post', 'uses' => 'UserController@store']);
    Route::post('/account/edit/{account}', 'UserController@storeAccount');
    Route::post('/account/edit/', 'UserController@storeAccount');
    Route::post('/user/delete', 'UserController@delete');
    Route::get('/user/profile', ['as' => 'user-profile', 'uses' => 'UserController@profile']);
    Route::post('/user/profile', 'UserController@postProfile');
    Route::post('/user/profile/password', 'UserController@postProfilePassword');
    Route::get('/user/mobile/verify', 'UserController@sendVerifyMobileToken');
    Route::get('/user/mobile/verify/{verifyMobileToken}', 'UserController@verifyMobile');
    Route::get('/account', ['middleware' => ['canAny:edit account'], 'uses' => 'AccountController@index']);
    Route::post('/account', ['middleware' => ['canAny:edit account data'], 'uses' => 'AccountController@store']);
    Route::get('/user/rating', ['middleware' => ['canAny:show own rating'], 'uses' => 'UserController@rate']);
    Route::get('/activate/{id}/{token}', 'Auth\AuthController@verifyEmail')->name('email.activation');
    Route::get('/sellers', ['middleware' => ['canAny:show seller'], 'as' => 'sellers', 'uses'=> 'SellerController@index']);

    // User - Fieldservice
    Route::get('/user/create-recruited', ['middleware' => ['canAny:create recruited users'], 'as' => 'create-recruited-user', 'uses' => 'UserController@createRecurited']);
    Route::post('/user/fieldservice-creates-seller', ['as' => 'fieldservice-creates-seller', 'uses' =>'UserController@storeCreateRecruited']);


    // Profiles
    // FIXME: add profile/consumer, we might change profile/seller to {account} in stead of user
    Route::get('/profile/{role}/{account}', ['as' => 'show-account-generic', 'uses' => 'UserController@showAccount']); //Display profile of choosen agent user
    Route::get('/profile/user/{account}', ['as' => 'show-user-account', 'uses' => 'UserController@showAccount']);
    Route::get('/profile/agent/{account}', ['as' => 'show-agent-account', 'uses' => 'UserController@showAccount']); //Display profile of choosen agent user
    Route::get('/profile/seller/{account}', ['as' => 'show-seller-account', 'uses' => 'UserController@showAccount']); //Display account of seller account
    Route::get('/profile/consumer/{account}', ['as' => 'show-consumer-account', 'uses' => 'UserController@showAccount']); //Display account of seller account



    //Coupon
    Route::model('couponTemplate', 'App\CouponTemplate');
    Route::get('/coupon', ['middleware' => ['canAny:show coupon management,show agent coupons'], 'uses' => 'CouponTemplateController@index']);
    Route::get('/coupon/seller/{account}', ['as' => 'coupon-templates-by-seller', 'uses' => 'CouponTemplateController@listBySeller']);
    Route::get('/coupon/edit', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@edit']);
    Route::post('/coupon/edit', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@store']);
    Route::get('/coupon/edit/{couponTemplate}', ['middleware' => ['canAny:create coupon template'], 'as' => 'coupon-id', 'uses' => 'CouponTemplateController@edit']);
    Route::post('/coupon/edit/{couponTemplate}', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@store']);
    Route::get('/coupon/delete/{couponTemplate}', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@delete']);
    Route::get('/coupon/status/{couponTemplate}/activate', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@activate']);
    Route::get('/coupon/status/{couponTemplate}/deactivate', ['middleware' => ['canAny:create coupon template'], 'uses' => 'CouponTemplateController@deactivate']);
    Route::post('/coupon/redeem', ['middleware' => ['canAny:redeem coupon'], 'as' => 'coupon-redeem', 'uses' => 'CouponController@store']);
    Route::get('/coupon/send/{couponTemplate}/{type?}', ['middleware' => ['canAny:show agent coupons'], 'as' => 'coupon-send', 'uses' => 'CouponTemplateController@send']);
    Route::post('/coupon/redeemed', ['middleware' => ['canAny:redeem coupon'], 'uses' => 'CouponController@redeemed']);
    Route::get('/coupon/get-image/{img}', 'CouponTemplateController@getImage')->name('coupon.get-image');
    Route::get('/coupon/get-cashback/{couponTemplate}', 'CouponTemplateController@getCashback')->name('coupon.get-cashback');

    Route::get('/coupons/share/{account}/{type?}', ['middleware' => ['canAny:show seller'], 'as' => 'share-coupons-from-seller', 'uses' => 'CouponTemplateController@shareCouponsFromSeller']);
    Route::post('/coupons/share/seller', ['middleware' => ['canAny:show seller'], 'as' => 'share-coupons-from-seller-post', 'uses' => 'CouponController@createSelectionCoupons']);

    Route::get('/coupons/share/{account}/{type?}', ['middleware' => ['canAny:show seller'], 'as' => 'share-coupons-from-seller', 'uses' => 'CouponTemplateController@shareCouponsFromSeller']);

    Route::post('/coupon/store', ['as' => 'share-coupons-template-post', 'uses' => 'CouponController@store']);
    Route::get('/coupon/redeem', ['middleware' => ['canAny:redeem coupon,show agent coupons'], 'as' => 'recommended-coupons', 'uses' => 'CouponController@redeem']);
    Route::get('/coupon/view/{coupon}', ['as' => 'coupon-view', 'uses' => 'CouponController@viewCoupon']);

    Route::get('/agent', ['middleware' => ['canAny:show agents'], 'uses' => 'AgentController@index']);
    Route::get('/agent/create', ['middleware' => ['canAny:invite agents'], 'uses' => 'AgentController@create']);
    Route::post('/agent/create', ['middleware' => ['canAny:invite agents'], 'uses' => 'AgentController@store']);
    Route::get('/agent/register', 'AgentController@registerAgent');

    Route::model('seller', 'App\User');
    Route::get('/agent/remove/{account}', ['middleware' => ['canAny:show agents'], 'as' => 'agent-account-remove', 'uses' => 'AgentController@remove']);
    Route::get('/agent/add/{account}', ['middleware' => ['canAny:show agents'], 'as' => 'agent-account-add', 'uses' => 'AgentController@add']);

    Route::get('/seller/remove/{account}', ['middleware' => ['canAny:show seller'], 'as' => 'seller-account-remove', 'uses' => 'AgentController@removeSellerAccount']);
    Route::get('/seller/add/{account}', ['middleware' => ['canAny:show seller'], 'as' => 'seller-account-add', 'uses' => 'AgentController@addSellerAccount']);

    Route::get('password/set/consumer/{token?}', 'Auth\AuthController@showSetPasswordForConsumerForm');
    Route::get('password/set/agent/{token?}', 'Auth\AuthController@showSetPasswordForAgentForm');
    Route::get('password/set/seller/{user}/{token?}', 'Auth\AuthController@showSetPasswordForSellerForm');
    Route::post('password/set', 'Auth\PasswordController@setUserPassword');

    Route::get('operator/reset', ['as' => 'operator-reset', 'uses' => 'Auth\PasswordController@sendResetLinkEmail']);

    //Mitarbeiterverwaltung
    Route::get('/member', ['middleware' => ['canAny:edit account'], 'uses' => 'AccountController@showMembers']);
    Route::post('/member/invite', ['middleware' => ['canAny:edit account data'], 'uses' => 'AccountController@inviteMember']);
    Route::get('password/set/member/{token?}', 'Auth\AuthController@showSetPasswordForAgentForm');

    // Invitations
    Route::model('invitation', 'App\Invitation');
    Route::get('/invitation', ['middleware' => ['canAny:show invitation'], 'uses' => 'InvitationController@index']);
    Route::get('invitation/accept/{invitation}', ['middleware' => ['canAny:show invitation'], 'uses' => 'InvitationController@accept']);
    Route::get('invitation/reject/{invitation}', ['middleware' => ['canAny:show invitation'], 'uses' => 'InvitationController@reject']);

    Route::model('coupon', 'App\Coupon');
    Route::get('coupon-invitation/accept/{coupon}', 'CouponController@accept');
    Route::get('coupon-invitation/reject/{coupon}', 'CouponController@reject');
    Route::get('/coupon/paid/{coupon}', ['middleware' => ['canAny:redeem coupon'], 'as' => 'coupon-paid', 'uses' => 'CouponController@paid']);
    Route::get('/coupon/assert-payment/{coupon}',
        ['middleware' => ['canAny:show consumer transactions'], 'as' => 'coupon-assert-payment', 'uses' => 'CouponController@assertPayment']
    );

    Route::get('generatePermanentLinkInvitation', 'Controller@generatePermanentLinkInvitation');


    // Job Queue
    Route::get('/queue', 'JobController@index');

    //Transaction
    Route::model('transaction', 'App\Transaction');
    Route::get('/transaction', ['middleware' => ['canAny:show operator transactions,show seller transactions,show agent transactions,show consumer transactions'], 'as' => 'transaction', 'uses' => 'TransactionController@index']);
    Route::post('/transaction/rate', 'TransactionController@rate');
    Route::get('/transaction/sepa_debit', ['middleware' => ['canAny:export sepa files'], 'as' => 'transaction-sepa-debit', 'uses' => 'TransactionController@sepaDebitDownload']);
    Route::get('/transaction/sepa_credit', ['middleware' => ['canAny:export sepa files'], 'as' => 'transaction-sepa-credit', 'uses' => 'TransactionController@sepaCreditDownload']);
    Route::get('/transaction/request_all_payments', ['as' => 'transaction-request-all-payments', 'uses' => 'TransactionController@requestAllPayments']);
    Route::get('/transaction/{name}', 'TransactionController@download');

    //Bank Transactions
    Route::get('/bank_transaction', ['middleware' => ['canAny:export sepa files'], 'uses' => 'BankTransactionController@index']);

    //Invoiceseller
    Route::model('invoice', 'App\Invoice');
    Route::get('/invoice/pdf/{invoice}', ['middleware' => 'auth', 'as' => 'invoice-downloadpdf', 'uses' => 'InvoiceController@downloadPdf']);

    Route::model('creditnote', 'App\CreditNote');
    //Credit noteInvoiceController@downloadPdf
    Route::get('/creditnote/pdf/{creditnote}', ['middleware' => 'auth', 'as' => 'creditNote-downloadpdf', 'uses' => 'CreditNoteController@downloadPdf']);

    Route::get('/imprint', ['as' => 'imprint', 'uses' => 'IndexController@imprint']);

    Route::get('/-{code}', ['as' => 'short_link', 'uses' => 'IndexController@shortLink'])->where('code', '[a-z0-9A-Z]+');

    Route::get('/contact', 'IndexController@contact');
    Route::get('/vorteile',['as' => 'advantages', 'uses' => 'IndexController@advantages']);

    Route::get('/faq', 'FaqController@index');

    //Recommend RECO.MA
    Route::get('/recommend', ['middleware' => ['canAny:recommend recoma'], 'uses' => 'RecommendationController@index']);
    Route::post('/recommend/create', 'RecommendationController@recommend');

    Route::get('/whatsapp/{reason}', ['middleware' => ['canAny:recommend recoma'], 'uses' => 'Controller@link']);
    Route::post('/registration', 'Controller@linkInvitation');
    Route::get('/registration/{token}', 'Controller@landingPage');
    Route::get('/registration/{token}/landing', 'Controller@preRegister');

    Route::get('/registration', 'Auth\AuthController@showUserRegistrationForm')->name('auth.register');
    Route::post('/user/register', 'Auth\AuthController@userRegister')->name('user.register');
    Route::get('/registration-seller', 'Auth\AuthController@showSellerRegistrationForm')->name('auth.register-seller');
    Route::post('/seller/register', 'Auth\AuthController@sellerRegister')->name('seller.register');

    //routes for buttons from amk for sharing whatsapp,email,sms
    Route::get('/recommend-recoma', 'RecommendationController@recommendRecoma')->name('recommendRecoma');
    Route::get('/share-seller/{account}', 'RecommendationController@shareSeller')->name('recommendSeller');
    Route::get('/share-coupon/{couponTemplate}', 'RecommendationController@shareCoupon')->name('shareCoupon');

    Route::get('/seller-invite-new-agent', 'RecommendationController@inviteNewAgent')->name('recommendAgent');


    Route::post('/send-mail-invitation-to-user', 'UserController@sendMailToUser');
    Route::post('/send-sms-invitation-to-user', 'UserController@sendSMSToUser');

    Route::get('/transfer', ['as' => 'transfer', 'uses' => 'CreditNoteController@transfer']);

    Route::model('banktransaction', 'App\BankTransaction');
    Route::get('/bank_transaction/set/{banktransaction}', ['middleware' => ['canAny:show operator transactions'], 'as' => 'set-bank_transaction-status', 'uses' => 'BankTransactionController@showSetStatus']);
    Route::post('/bank_transaction', 'BankTransactionController@setStatus');


    //agent Newsletter
    Route::model('accountConnection', 'App\AccountConnection');
    Route::get('newsletter/accept/{accountConnection}', ['middleware' => ['canAny:show invitation'], 'uses' => 'NewsletterController@accept']);
    Route::get('newsletter/reject/{accountConnection}', ['middleware' => ['canAny:show invitation'], 'uses' => 'NewsletterController@reject']);
    Route::get('newsletter/acceptConnectionViaEmailButton/{token}', ['as'=> 'acceptConnectionViaEmailButton','uses'=>'NewsletterController@acceptConnectionViaEmailButton']);



    });


    Route::group(['middleware'=>'canShowOnboardingAgent'],function () {
    //Onboarding Agent
        Route::get('/onboarding-agent', ['as' => 'onboarding-agent', 'uses' => 'Onboarding\OnboardingAgentController@index']);
        Route::post('/onboarding-agent-insert-profile-data', ['as' => 'onboarding-agent-insert-profile-data', 'uses' => 'Onboarding\OnboardingAgentController@setProfileData']);
        Route::post('/onboarding-agent-notice-seller', ['as' => 'onboarding-agent-notice-seller', 'uses' => 'Onboarding\OnboardingAgentController@noticeSeller']);
        Route::post('/onboarding-recommend-seller-email', ['as' => 'onboarding-recommend-seller-email', 'uses' => 'UserController@sendMailToUser']);
        Route::post('/onboarding-recommend-seller-sms', ['as' => 'onboarding-recommend-seller-sms', 'uses' => 'UserController@sendSMSToUser']);
    });

    Route::group(['middleware'=>'canShowOnboardingSeller'],function () {
    //Onboarding Seller
        Route::get('/onboarding-seller', ['as' => 'onboarding-seller', 'uses' => 'Onboarding\OnboardingSellerController@index']);
        Route::get('/onboarding-seller-increase-level', ['as' => 'onboarding-seller-increase-level', 'uses' => 'Onboarding\OnboardingSellerController@increaseOnboardingLevel']);
        Route::post('/onboarding-seller-invite-agents', ['as' => 'onboarding-seller-invite-agents', 'uses' => 'Onboarding\OnboardingSellerController@inviteAgents']);
        Route::post('/onboarding-seller-create-coupon', ['as' => 'onboarding-seller-create-coupon', 'uses' => 'CouponTemplateController@store']);
        Route::post('/onboarding-seller-update-profile-company', ['as' => 'onboarding-seller-update-profile-company', 'uses' => 'Onboarding\OnboardingSellerController@updateSellerCompanyOverlay']);
        Route::post('/onboarding-seller-update-payment-company', ['as' => 'onboarding-seller-update-payment-company', 'uses' => 'Onboarding\OnboardingSellerController@updateSellerPaymentOverlay']);
        Route::post('/onboarding-seller-update-accountImg-newsletter', ['as' => 'onboarding-seller-update-accountImg-newsletter', 'uses' => 'Onboarding\OnboardingSellerController@updateDataFromSellerCreatedByAdmOrOperator']);

    });

    // categories
    Route::group(['prefix' => 'categories'], function () {
        Route::get('/', 'CategoryController@index')
            ->middleware('canAny:show categories')
            ->name('category-list');
        Route::get('/create', 'CategoryController@create')
            ->middleware('canAny:create categories')
            ->name('category-create');
        Route::post('/', 'CategoryController@store')
            ->middleware('canAny:create categories')
            ->name('category-store');
        Route::get('/{category}/edit', 'CategoryController@edit')
            ->middleware('canAny:edit categories')
            ->name('category-edit');
        Route::get('/{category}/up', 'CategoryController@up')
            ->middleware('canAny:edit categories')
            ->name('category-up');
        Route::get('/{category}/down', 'CategoryController@down')
            ->middleware('canAny:edit categories')
            ->name('category-down');
        Route::put('/{category}', 'CategoryController@update')
            ->middleware('canAny:edit categories')
            ->name('category-update');
        Route::delete('/{category}', 'CategoryController@destroy')
            ->middleware('canAny:delete categories')
            ->name('category-delete');
    });

    // widgets (managing and init)
    Route::group(['prefix' => 'widgets'], function () {
        Route::get('/deals/{alias}', 'WidgetController@deals')
            ->name('widget-deals');
        Route::get('/invite/{alias}', 'WidgetController@invite')
            ->name('widget-invite');
        // WERU special widget
        Route::get('/weru', 'WidgetController@weru')
            ->name('widget-weru');
    });

    // widgets (embed)
    Route::group(['prefix' => 'embed'], function () {
        Route::get('/deals/{alias}', 'WidgetController@dealsEmbed')
            ->name('embed-deals');
        Route::get('/invite/{alias}', 'WidgetController@inviteEmbed')
            ->name('embed-invite');
        // WERU special widget
        Route::get('weru', 'WidgetController@weruEmbed')
            ->name('embed-weru');
    });

    // helpers
    Route::get('/userpic/{user}', 'ImageController@getUserpic')
        ->name('get-userpic');

    // gifts
    Route::group(['prefix' => 'gifts'], function () {
        Route::get('/', 'GiftController@index')
            ->middleware('canAny:show gifts')
            ->name('gift-list');
        Route::get('/create', 'GiftController@create')
            ->middleware('canAny:create gifts')
            ->name('gift-create');
        Route::post('/', 'GiftController@store')
            ->middleware('canAny:create gifts')
            ->name('gift-store');
        Route::get('/{gift}/edit', 'GiftController@edit')
            ->middleware('canAny:edit gifts')
            ->name('gift-edit');
        Route::put('/{gift}', 'GiftController@update')
            ->middleware('canAny:edit gifts')
            ->name('gift-update');
        Route::delete('/{gift}', 'GiftController@destroy')
            ->middleware('canAny:delete gifts')
            ->name('gift-delete');
        Route::get('/{gift}', 'GiftController@show')
            ->middleware('auth')
            ->name('gift-show');
        Route::get('/{gift}/activate', 'GiftController@activate')
            ->middleware('canAny:edit gifts')
            ->name('gift-activate');
        Route::get('/{gift}/deactivate', 'GiftController@deactivate')
            ->middleware('canAny:edit gifts')
            ->name('gift-deactivate');
    });

    // users gifts
    Route::group(['prefix' => 'usersgifts'], function () {
        Route::get('/', 'UsersGiftController@index')
            ->middleware('canAny:show users gifts')
            ->name('usersgift-list');
        Route::put('/{usersGift}/sent', 'UsersGiftController@markAsSent')
            ->middleware('canAny:edit users gifts')
            ->name('owngift-mark-sent');
    });

    // own gifts
    Route::group(['prefix' => 'my-gifts'], function () {
        Route::get('/', 'UsersGiftController@own')
            ->middleware('canAny:show own gifts')
            ->name('owngift-list');
        Route::get('/{usersGift}/edit', 'UsersGiftController@edit')
            ->name('owngift-edit');
        Route::put('/{usersGift}', 'UsersGiftController@update')
            ->name('owngift-update');
        Route::put('/{usersGift}/received', 'UsersGiftController@markAsReceived')
            ->name('owngift-mark-received');
    });

    Route::post('/alias', 'UserController@setAlias')->name('set-alias');

    // options
    Route::group(['prefix' => 'options'], function () {
        Route::post('/{user}/global', 'OptionsController@saveGlobalWidgetOptions')
            ->middleware('canDo:edit widgets')
            ->name('save-global-widget-options');
        Route::post('/{user}/invite', 'OptionsController@saveInviteWidgetOptions')
            ->middleware('canDo:edit widgets')
            ->name('save-invite-widget-options');
    });

    Route::get('/agb', 'IndexController@agb')->name('agb');
    Route::get('/datenschutz', 'IndexController@privacy')->name('privacy');
    Route::get('/impressum', 'IndexController@impressum')->name('impressum');
    Route::get('/faq', 'IndexController@faq')->name('faq');
    Route::get('/business', 'IndexController@business')->name('business');
    Route::get('/landing', 'IndexController@landing')->name('landing');

    Route::get('/seller/{alias}', 'SellerController@showSellerPage')
        ->name('seller.index');
    Route::get('/deal/{couponTemplate}', 'CouponTemplateController@dealOld')
        ->name('deal.index');

    Route::group(['middleware' => ['auth', 'tfa', 'active']], function () {
        Route::group(['middleware' => 'user'], function () {
            Route::get('board', 'DashboardController@user')
                ->name('user.dashboard');
            Route::post('/fav/{couponTemplate}', 'CouponTemplateController@favoriteToggle')
                ->name('deal.favorite-toggle');
            Route::post('/unfav/{couponTemplate}', 'CouponTemplateController@unfavorite')
                ->name('deal.unvaforite');
            Route::get('/profile', 'UserController@userProfile')
                ->name('user.profile');
            Route::get('/fav', 'UserController@favorites')
                ->name('user.fav');
            Route::get('/account', 'UserController@transactions')
                ->name('user.transactions');
            Route::get('/referrals', 'UserController@referrals')
                ->name('user.referrals');
            Route::get('/sellers', 'UserController@sellers')
                ->name('user.sellers');
            Route::get('/reviews', 'UserController@reviews')
                ->name('user.reviews');
            Route::get('/coupons', 'UserController@coupons')
                ->name('user.coupons');
            Route::get('/coupon/{coupon}/view', 'CouponController@getCouponView')
                ->name('coupon.get');
            Route::get('/coupon/{coupon}/print', 'CouponController@print')
                ->name('coupon.print');
            Route::get('/payout', 'UserController@payout')
                ->name('user.payout');
        });

        Route::post('/user/setname', 'UserController@setName')
            ->name('user.set-name');
        Route::post('/user/setbanking', 'UserController@setBankingData')
            ->name('user.set-banking');
        Route::post('/user/setuserpic', 'UserController@setUserpic')
            ->name('user.set-userpic');
        Route::post('/seller/setlogo', 'UserController@setLogo')
            ->name('user.set-logo');
        Route::post('/seller/setpicture', 'UserController@setPicture')
            ->name('user.set-picture');

        Route::get('/user/flush_sessions', 'UserController@flushSessions')
            ->name('user.flush-sessions');
    });

    Route::get('/ref/{alias}', 'Auth\AuthController@registerWithReferrer')
        ->name('user.referral-link');
    Route::get('/invite/{alias}', 'Auth\AuthController@registerSellerWithReferrer')
        ->name('user.seller-invite-link');

    Route::get('/category/{hierarchy}', 'CategoryController@category')
        ->where('hierarchy','^[a-zA-Z0-9-_\/]+$')
        ->name('category.index')
        ->middleware('openSystem');
    Route::any('/search/', 'SearchController@index')
        ->name('search')
        ->middleware('openSystem');

    Route::get('/deals', 'DealsController@index')
        ->name('deals.index');

    Route::group(['middleware' => ['auth', 'tfa', 'hasRole:seller,employee', 'active']], function () {
        Route::group(['prefix' => 'dashboard'], function () {
            Route::get('/', 'DashboardController@seller')->name('seller.dashboard');

            // agents
            Route::get('/agents', 'SellerController@agents')
                ->middleware('canDo:view agents')
                ->name('seller.agents.index');

            // coupons
            Route::get('/coupons', 'CouponController@sellerIndex')
                ->middleware('canDo:view coupons')
                ->name('seller.coupons.index');
            Route::get('/coupon/redeem', 'CouponController@redeemingIndex')
                ->middleware('canDo:redeem coupons')
                ->name('seller.coupon.redeeming.index');

            // deals
            Route::get('/deals', 'DealsController@sellerIndex')
                ->middleware('canDo:view deals')
                ->name('seller.deals.index');
            Route::get('/deals/create', 'CouponTemplateController@create')
                ->middleware('canDo:create deals')
                ->name('seller.deal.create');
            Route::get('/deals/{couponTemplate}/edit', 'CouponTemplateController@update')
                ->middleware('canDo:edit deals')
                ->name('seller.deal.edit');
            Route::get('/deals/{couponTemplate}/activate', 'CouponTemplateController@activate')
                ->middleware('canDo:edit deals')
                ->name('seller.deal.activate');
            Route::get('/deals/{couponTemplate}/deactivate', 'CouponTemplateController@deactivate')
                ->middleware('canDo:edit deals')
                ->name('seller.deal.deactivate');
            Route::delete('/deals/{couponTemplate}', 'CouponTemplateController@delete')
                ->middleware('canDo:edit deals')
                ->name('seller.deal.delete');

            // transactions
            Route::get('/transactions', 'TransactionController@sellerIndex')
                ->middleware('canDo:view transactions')
                ->name('seller.transactions.index');

            // share
            Route::get('/share', 'SellerController@share')
                ->middleware('canDo:share reflink')
                ->name('seller.share.index');
            Route::get('/invite-sellers', 'SellerController@inviteSellers')
                ->middleware('canDo:invite sellers')
                ->name('seller.invite-sellers.index');

            // widgets
            Route::get('/widgets', 'WidgetController@index')
                ->middleware('canDo:view widgets')
                ->name('seller.widgets.index');
            Route::get('/widgets/preview/deals', 'WidgetController@dealsPreview')
                ->middleware('canDo:view widgets')
                ->name('seller.widgets.preview.deals');
            Route::get('/widgets/preview/invite', 'WidgetController@invitePreview')
                ->middleware('canDo:view widgets')
                ->name('seller.widgets.preview.invite');

            // reviews
            Route::get('/reviews', 'SellerController@reviews')
                ->middleware('canDo:view reviews')
                ->name('seller.reviews.index');

            // profile
            Route::get('/profile', 'SellerController@profile')
                ->name('seller.profile.index');

            // company
            Route::get('/company', 'SellerController@company')
                ->middleware('canDo:view company data')
                ->name('seller.company.index');

            // places
            Route::get('/places', 'PlacesController@index')
                ->middleware('canDo:view places')
                ->name('seller.places.index');
            Route::get('/places/store', 'PlacesController@store')
                ->middleware('canDo:create places')
                ->name('seller.place.store');
            Route::post('/places/create', 'PlacesController@create')
                ->middleware('canDo:create places')
                ->name('seller.place.create');
            Route::get('/places/{place}/edit', 'PlacesController@edit')
                ->middleware('canDo:edit places')
                ->name('seller.place.edit');
            Route::post('/places/{place}/update', 'PlacesController@update')
                ->middleware('canDo:edit places')
                ->name('seller.place.update');
            Route::get('/places/{place}/activate', 'PlacesController@activate')
                ->middleware('canDo:edit places')
                ->name('seller.place.activate');
            Route::get('/places/{place}/deactivate', 'PlacesController@deactivate')
                ->middleware('canDo:edit places')
                ->name('seller.place.deactivate');
            Route::delete('/places/{place}', 'PlacesController@delete')
                ->middleware('canDo:edit places')
                ->name('seller.place.delete');

            // employees
            Route::group(['middleware' => 'seller'], function () {
                Route::get('/employees', 'EmployeesController@index')
                    ->name('seller.employees.index');
                Route::get('/employees/store', 'EmployeesController@store')
                    ->name('seller.employee.store');
                Route::post('/employees/create', 'EmployeesController@create')
                    ->name('seller.employee.create');
                Route::get('/employees/{user}/edit', 'EmployeesController@edit')
                    ->name('seller.employee.edit');
                Route::post('/employees/{user}/update', 'EmployeesController@update')
                    ->name('seller.employee.update');
                Route::get('/employees/{user}/activate', 'EmployeesController@activate')
                    ->name('seller.employee.activate');
                Route::get('/employees/{user}/deactivate', 'EmployeesController@deactivate')
                    ->name('seller.employee.deactivate');
                Route::delete('/employees/{user}', 'EmployeesController@delete')
                    ->name('seller.employee.delete');
                Route::get('/employees/activity', 'EmployeesController@activityIndex')
                    ->name('seller.employees.activity');
            });
        });
    });

    Route::group(['middleware' => 'auth'], function () {
        // paypal
        Route::group(['prefix' => 'paypal'], function () {
            Route::get('/connect', 'PayPalController@connect')
                ->name('paypal.connect');
            Route::get('/disconnect', 'PayPalController@disconnect')
                ->name('paypal.disconnect');
        });

        // TFA
        Route::get('tfa', 'TFAController@index')->name('tfa.index');
        Route::post('tfa', 'TFAController@verify')->name('tfa.verify');
        Route::get('tfa/google/connect', 'TFAController@googleConnect')->name('tfa.google-connect');
        Route::get('tfa/google/disconnect', 'TFAController@googleDisconnect')->name('tfa.google-disconnect');
    });

    Route::get('/employee/activation/{user}/{token}', 'EmployeesController@activation')
        ->name('employee.activation');
    Route::post('/employee/{user}/register/', 'EmployeesController@register')
        ->name('employee.register');

	Route::get('landing', 'HomeController@landing');
		
    Route::get('t', function () {
        //
    });

//});

/*
Route::group(['domain' => '{alias}.' . env('SITE_URL', 'reco.ma')], function () {
    Route::get('/', 'SellerController@showSellerPage')
        ->name('seller.index');
    Route::get('/deal/{couponTemplate}', 'CouponTemplateController@deal')
        ->name('deal.index');
});
*/