<?php

Route::post('login', 'UserController@login')
    ->name('api.login');
Route::post('register', 'UserController@register')
    ->name('api.register');
Route::post('islogged', 'UserController@isLogged')
    ->name('api.is-logged');

Route::post('share_reflink/email', 'ShareController@shareReferralLinkViaEmail')
    ->name('api.reflink.share-email');
Route::post('share_invitelink/email', 'ShareController@shareInviteLinkViaEmail')
    ->name('api.invitelink.share-email');
Route::post('reflinks/seller/{user}', 'ReflinkController@getSellerLinks')
    ->name('api.reflink.seller');
Route::post('reflinks/deal/{couponTemplate}', 'ReflinkController@getDealLinks')
    ->name('api.reflink.deal');

Route::post('/coupon/getbycode', 'CouponController@getByCode')
    ->name('api.coupon-get-by-code');
Route::post('/coupon/cashback', 'CouponController@calculateCashback')
    ->name('api.coupon-calculate-cashback');

Route::group(['middleware' => 'auth'], function () {
    Route::post('/deal/{couponTemplate}/getcashback', 'DealController@getCashback')
        ->name('api.get-cashback');
    Route::post('/deal/update', 'DealController@update')
        ->name('api.deal-update');
    Route::post('/deal/{couponTemplate}/rate', 'DealController@rate')
        ->name('api.rate-deal');

    Route::post('/coupon/{coupon}/rate', 'CouponController@rate')
        ->name('api.rate-coupon');
    Route::delete('/coupon/{coupon}', 'CouponController@delete')
        ->name('api.delete-coupon');
    Route::post('/coupon/{coupon}/paid', 'CouponController@markAsPaid')
        ->name('api.coupon.mark-as-paid');
    Route::post('/change_password', 'UserController@changePassword')
        ->name('api.change-password');
    Route::post('/change_address', 'UserController@changeAddress')
        ->name('api.change-address');
    Route::post('/change_company_address', 'UserController@changeCompanyAddress')
        ->name('api.change-company-address');
    Route::post('/change_personal', 'UserController@changePersonal')
        ->name('api.change-personal');
    Route::post('/change_contacts', 'UserController@changeContacts')
        ->name('api.change-contacts');
    Route::post('/change_email', 'UserController@changeEmail')
        ->name('api.change-email');
    Route::post('/change_banking', 'UserController@changeBanking')
        ->name('api.change-banking');
    Route::post('/change_alias', 'UserController@changeAlias')
        ->name('api.change-alias');
    Route::post('/change_company', 'UserController@changeCompany')
        ->name('api.change-company');
    Route::post('/change_worktimes', 'UserController@changeWorktimes')
        ->name('api.change-worktimes');

    Route::post('/coupon/redeem', 'CouponController@redeem')
        ->name('api.redeem-coupon');

    Route::post('/usersgift/{usersGift}/setaddress', 'UsersGiftController@setAddress')
        ->name('api.usersgift.set-address');
    Route::post('/usersgift/{usersGift}/received', 'UsersGiftController@markAsReceived')
        ->name('api.usersgift.mark-as-received');

    Route::post('/share/register', 'ShareController@registerShare')
        ->name('api.share-register');

    Route::post('/upload', 'MediaController@upload')
        ->name('api.media.upload');

    Route::post('/user/remove', 'UserController@remove')
        ->name('api.user.remove');

    Route::post('/payout', 'PayOutController@payout');

    Route::post('/newsletter/subscribe', 'NewsletterController@subscribe')
        ->name('newsletter.subscribe');
    Route::post('/newsletter/unsubscribe', 'NewsletterController@unsubscribe')
        ->name('newsletter.unsubscribe');

    Route::post('/email/sendtoken', 'UserController@sendEmailVerificationToken')
        ->name('email.send-token');

    Route::post('/employee/{user}/sendlink', 'EmployeeController@sendRegistrationLink')
        ->name('employee.send-link');

    Route::post('/activity/get', 'ActivityController@getDetailedActivity')
        ->name('activity.get-detailed');
    Route::post('/activity/{user}/get', 'ActivityController@getActivity')
        ->name('activity.get');

    // options
    Route::get('/option/{option}', 'OptionsController@get')
        ->name('option.get');
    Route::post('/option/{option}', 'OptionsController@set')
        ->name('option.set');

    // favorites
    Route::post('/fav/{couponTemplate}', 'DealController@favoriteToggle')
        ->name('deal.toggle-favorite');
});

Route::post('/cities/find', 'CityController@find')
    ->name('api.city-find');

Route::post('/search', 'SearchController@search')
    ->name('api.search');

Route::post('/password/strength', 'PasswordController@checkStrength')
    ->name('api.password-strength');

Route::post('/tfa/connect', 'TFAController@getTFAConnectionData');
Route::post('/tfa/finish', 'TFAController@finishTFAConnection');