(function (global) {
    @include('widgets.embed.partials.xd')

    var _id = 'recoma-weru-widget';

    var el = document.createElement('iframe');
    el.id = _id;
    el.style.display = 'none';
    el.style.position = 'fixed';
    el.style.background = '#fff';
    el.style.top = '50%';
    el.style.marginTop = '-250px';
    el.style.left = '-1045px';
    el.style.border = 'none';
    el.style.zIndex = 2000;
    el.scrolling = 'no';
    el.frameborder = 'no';
    el.src = '{{ route('embed-weru') }}#' + encodeURIComponent(document.location.href);
    document.body.appendChild(el);
    el.onload = function () {
        setTimeout(_resize, 100);
    };

    var st = document.createElement('style');
    st.innerText = '#' + _id + '{transition:0.5s}';
    st.innerText += '#' + _id + '.opened{left:0 !important;}';
    document.body.appendChild(st);

    var _resize = function () {
        var h = window.innerHeight;
        var w = window.innerWidth;
        if (h < 500 || w < 1075) {
            el.style.display = 'none';
        } else {
            el.style.display = 'block';
        }
    };

    XD.receiveMessage(function(msg) {
        if (msg.data && msg.data.target == _id && document.getElementById(_id)) {
            if ('resize' === msg.data.action) {
                el.style.display = 'block';
                document.getElementById(_id).height = msg.data.height;
                document.getElementById(_id).width = msg.data.width;
            } else if ('toggle' === msg.data.action) {
                el.classList.toggle('opened');
            }
        }
    }, '{{ Request::secure() ? 'https://' : 'http://' }}' + '{{ Request::getHost() }}');

    window.addEventListener('resize', _resize, true);
})(this)