(function (global) {
    @include('widgets.embed.partials.xd')
    var _id = 'recoma-deals-widget';
    var _togglerClass = 'recoma-deals-widget-toggler';
    var _src = '{{ route('embed-deals', ['seller' => $seller->alias]) }}#' + encodeURIComponent(document.location.href);
    var _p = null;

    var el = document.createElement('iframe');
    el.id = _id;
    el.style.position = 'fixed'
    el.style.top = '0';
    el.style.left = '0';
    el.style.width = '100%';
    el.style.height = '100%';
    el.style.border = 'none';
    el.style.zIndex = 2001;
    el.style.display = 'none';
    el.frameborder = 'no';
    el.src = _src;
    document.body.appendChild(el);

    var style = document.createElement('style');
    style.innerText =
        '.deals-opened{overflow:hidden}' +
        '#recoma-deals-widget-toggler{ transition: 0.4s all; background: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }}; color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }}; }' +
        '#recoma-deals-widget-toggler:hover{ background: {{ $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h') }}; color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }}; }';
    document.head.appendChild(style);

    var showDeals = function () {
        document.getElementById(_id).style.display = 'block';
        document.body.classList.add('deals-opened');
    };

    var hideDeals = function () {
        document.getElementById(_id).style.display = 'none';
        document.body.classList.remove('deals-opened');
    };

    var togglers = document.getElementsByClassName(_togglerClass);
    if (!togglers.length) {
        var el = document.createElement('div');
        el.id = _togglerClass;
        el.className = _togglerClass;
        el.style.position = 'fixed'
        el.style.bottom = '10px';
        el.style.left = '10px';
        el.style.width = '100px';
        el.style.height = '40px';
        el.style.lineHeight = '40px';
        el.style.fontSize = '20px';
        el.style.textAlign = 'center';
        el.style.textTransform = 'uppercase';
        el.style.cursor = 'pointer';
        el.style.borderRadius = '4px';
        el.style.fontFamily = 'sans-serif';
        el.innerText = 'Deals';
        el.style.zIndex = 1999;
        el.onclick = function () {
            showDeals();
        };
        document.body.appendChild(el);
    } else {
        var i = 0; l = togglers.length;
        for (i; i < l; i++) {
            togglers[i].addEventListener('click', function () {
                showDeals();
            });
        }
    }

    XD.receiveMessage(function(msg) {
        if (msg.data && msg.data.target == _id && document.getElementById(_id)) {
            if ('hide' === msg.data.action) {
                hideDeals();
            }
        }
    }, '{{ Request::secure() ? 'https://' : 'http://' }}' + '{{ Request::getHost() }}');
})(this)