@extends('layouts.home')

@section('title', 'Widgets')

@section('content')
    <div class="row">
        <div class="col-md-12">
            @if( !$availableCouponTemplates->count() )
                <div class="alert alert-danger">
                    Du hast aktive Kampagne nicht.
                </div>
            @endif

            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Widgets Einstellungen</h5>
                </div>
                <div class="ibox-content">
                    <form class="form-horizontal" action="{{ route('save-global-widget-options', ['user' => $user]) }}" method="post">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('main_bg') ? ' has-error' : '' }}">
                            <label class="col-sm-2 control-label" for="main_bg">Hauptfarbe (Rahmen, Knopfe Hintergrund)</label>
                            <div class="col-sm-10">
                                <input type="color"
                                       id="main_bg"
                                       name="main_bg"
                                       value="{{ old('main_bg', $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg')) }}"
                                >
                                <input type="text"
                                       data-helpto="#main_bg"
                                       class="color-picker-helper"
                                       pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                                       maxlength="7"
                                       value="{{ old('main_bg', $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg')) }}"
                                >
                            </div>

                            @include('partials.form.error', ['property' => 'main_bg'])
                        </div>

                        <div class="form-group{{ $errors->has('main_txt') ? ' has-error' : '' }}">
                            <label class="col-sm-2 control-label" for="main_txt">Textfarbe</label>
                            <div class="col-sm-10">
                                <input type="color"
                                       id="main_txt"
                                       name="main_txt"
                                       value="{{ old('main_txt', $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt')) }}"
                                >
                                <input type="text"
                                       data-helpto="#main_txt"
                                       class="color-picker-helper"
                                       pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                                       maxlength="7"
                                       value="{{ old('main_txt', $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt')) }}"
                                >
                            </div>

                            @include('partials.form.error', ['property' => 'main_txt'])
                        </div>

                        <div class="form-group{{ $errors->has('main_bg_h') ? ' has-error' : '' }}">
                            <label class="col-sm-2 control-label" for="main_bg_h">Hauptfarbe (Hover)</label>
                            <div class="col-sm-10">
                                <input type="color"
                                       id="main_bg_h"
                                       name="main_bg_h"
                                       value="{{ old('main_bg_h', $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h')) }}"
                                >
                                <input type="text"
                                       data-helpto="#main_bg_h"
                                       class="color-picker-helper"
                                       pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                                       maxlength="7"
                                       value="{{ old('main_bg_h', $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h')) }}"
                                >
                            </div>

                            @include('partials.form.error', ['property' => 'main_bg_h'])
                        </div>

                        <div class="form-group{{ $errors->has('main_txt_h') ? ' has-error' : '' }}">
                            <label class="col-sm-2 control-label" for="main_txt_h">Textfarbe (Hover)</label>
                            <div class="col-sm-10">
                                <input type="color"
                                       id="main_txt_h"
                                       name="main_txt_h"
                                       value="{{ old('main_txt_h', $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h')) }}"
                                >
                                <input type="text"
                                       data-helpto="#main_txt_h"
                                       class="color-picker-helper"
                                       pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                                       maxlength="7"
                                       value="{{ old('main_txt_h', $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h')) }}"
                                >
                            </div>

                            @include('partials.form.error', ['property' => 'main_txt_h'])
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label"></label>
                            <div class="col-sm-10">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save"></i> Speichern
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Recommendation widget</h5>
                </div>
                <div class="ibox-content">
                    <form class="form-horizontal" action="{{ route('save-invite-widget-options', ['user' => $user]) }}" method="post">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('deal') ? ' has-error' : '' }}">
                            <label class="col-sm-2 control-label" for="deal">Widget Kampagne</label>
                            <div class="col-sm-10">
                                @foreach($availableCouponTemplates as $deal)
                                    <p>
                                        <label for="deal_{{ $deal->id }}">
                                            <input type="radio"
                                                   name="deal"
                                                   value="{{ $deal->id }}"
                                                   id="deal_{{ $deal->id }}"
                                                   @if( isset($options['invite.deal_id']) && $deal->id === (int)$options['invite.deal_id']->value ) checked @endif
                                            >
                                            <span>{{ $deal->title }} ({{ $deal->present()->provisionAgent }} provision, {{ $deal->present()->discountConsumer }} cashback)</span>
                                        </label>
                                    </p>
                                @endforeach

                                @include('partials.form.error', ['property' => 'deal'])
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label"></label>
                            <div class="col-sm-10">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save"></i> Speichern
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="widgetCodeHolder">
                        {{ $widgetInviteCode }}
                    </div>
                </div>
            </div>

            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Kampagnen widget</h5>
                </div>
                <div class="ibox-content">
                    <div class="widgetCodeHolder">
                        {{ $widgetDealsCode }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $(document).ready(function () {
            $('input[type="color"]').on('change', function () {
                var id = '#' + $(this).attr('id');
                $('input[data-helpto="' + id + '"]').val($(this).val());
            });
            $('input[data-helpto]').on('keyup change', function () {
                var id = $(this).data('helpto');
                $(id).val($(this).val());
            });
        });
    </script>
@endsection