var _requestInProcess = false;

var _disableBtns = function () {
    var controls = document.querySelectorAll('[data-stop]');
    var i = 0; l = controls.length;
    for (i; i < l; i++) {
        controls[i].classList.add('disabled');
    }
};

var _enableBtns = function () {
    var controls = document.querySelectorAll('[data-stop]');
    var i = 0; l = controls.length;
    for (i; i < l; i++) {
        controls[i].classList.remove('disabled');
    }
};

var _postAjax = function (url, data, onSuccess, onError) {
    _requestInProcess = true;

    _disableBtns();

    var params = typeof data == 'string' ? data : Object.keys(data).map(
        function (k) {
            return encodeURIComponent(k) + '=' + encodeURIComponent(data[k])
        }
    ).join('&');

    var xhr = window.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject("Microsoft.XMLHTTP");
    xhr.open('POST', url);
    xhr.onreadystatechange = function () {
        if (xhr.readyState > 3) {
            _requestInProcess = false;
            _enableBtns();
            var r = _isJson(xhr.responseText) ? JSON.parse(xhr.responseText) : {'error' : xhr.responseText};
            if (200 === xhr.status) {
                onSuccess(r);
            } else {
                onError(r);
            }
        }
    };
    xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.setRequestHeader('X-CSRF-TOKEN', '{{ csrf_token() }}');
    xhr.send(params);
    return xhr;
};

var _isJson = function (item) {
    item = ('string' !== typeof item) ? JSON.stringify(item) : item;

    try {
        item = JSON.parse(item);
    } catch (e) {
        return false;
    }

    if (typeof item === "object" && item !== null) {
        return true;
    }

    return false;
};

var _validateEmail = function (email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
};

var _ucfirst = function (string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
};

var _show = function (el) {
    if ('undefined' === typeof el) {
        return;
    }
    if ('undefined' !== typeof el.length) {
        var i = 0, l = el.length;
        for (i; i < l; i++) {
            el[i].style.display = 'block';
        }
    } else {
        el.style.display = 'block';
    }
};

var _hide = function (el) {
    if ('undefined' === typeof el) {
        return;
    }
    if ('undefined' !== typeof el.length) {
        var i = 0, l = el.length;
        for (i; i < l; i++) {
            el[i].style.display = 'none';
        }
    } else {
        el.style.display = 'none';
    }
};

var _showStep = function (step) {
    var callback = callback || function () {};
    var step = 'step' + _ucfirst(step);
    var steps = document.getElementsByClassName('step');
    var i = 0;
    var l = steps.length;
    for (i; i < l; i++) {
        _hide(steps[i]);
    }
    _show(document.getElementById(step));
    _hide(stepsOverlay);
    _hide(msgHolder);
    _show(stepsCloseBtn);
};

var _showError = function (data) {
    _showMsg(data, 'error');
};

var _showSuccess = function (data) {
    _showMsg(data, 'success');
};

var _showMsg = function (data, state) {
    var holder = document.getElementById('msgHolder');
    var title = document.getElementById('msgTitle');
    title.innerText = ('error' === state) ? 'Fehler' : 'Erfolg';
    holder.className = state;
    _show(holder);
    var text = [];
    var bag = data.error || data;
    if ('object' === typeof bag) {
        for (i in bag) {
            text.push(bag[i]);
        }
    } else if ('undefined' !== typeof bag) {
        text.push(bag);
    } else {
        text.push(data);
    }
    document.getElementById('msgText').innerHTML = text.join('<br>');
};

var _api = function (url, data, onSuccess, onError) {
    var data = data || {};
    var onSuccess = onSuccess || function () {};
    var onError = onError || function () {};
    _postAjax(url, data, function (response) {
        onSuccess(response);
    }, function (response) {
        onError(response);
    });
};

var _showStepElements = document.querySelectorAll('[data-show-step]');
var i = 0, l = _showStepElements.length;
for (i; i < l; i++) {
    _showStepElements[i].addEventListener('click', function () {
        _showStep(this.getAttribute('data-show-step'));
    });
}

var _isLogged = function (yes, no) {
    _hide(msgHolder);
    _showStep('blank');
    _show(stepsOverlay);
    _hide(stepsCloseBtn);
    _api('{{ route('api.is-logged') }}', {}, function (response) {
        yes(response);
    }, function (error) {
        no(error);
    });
};

var _extractDomain = function (data) {
    var a = document.createElement('a');
    a.href = data;
    return a.protocol + '//' + a.hostname;
}

var parent_url = decodeURIComponent(document.location.hash.replace(/^#/, ''));
var parent_domain = _extractDomain(parent_url);

var msgCloseBtn = document.getElementById('msgCloseBtn');
msgCloseBtn.addEventListener('click', function () {
    _hide(msgHolder);
});