<script>
    @include('widgets.embed.partials.xd')

    window.fbAsyncInit = function() {
        FB.init({
            appId            : {{ config('services.facebook.app_id') }},
            autoLogAppEvents : true,
            xfbml            : true,
            version          : 'v3.2'
        });
    };

    (function(d, s, id){
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) {return;}
        js = d.createElement(s); js.id = id;
        js.src = "https://connect.facebook.net/en_US/sdk.js";
        fjs.parentNode.insertBefore(js, fjs);
    }(document, 'script', 'facebook-jssdk'));

    document.addEventListener("DOMContentLoaded", function() {
        @include('widgets.embed.partials.js-common')

        var _id = 'recoma-invite-widget';

        var bubble = document.getElementById('bubble');
        var stepsHolder = document.getElementById('stepsHolder');
        var stepsOverlay = document.getElementById('stepsOverlay');
        var emailSendBtn = document.getElementById('emailSendBtn');
        var registerFirst = document.getElementById('registerFirst');
        var registerSecond = document.getElementById('registerSecond');
        var registerProceedBtn = document.getElementById('registerProceedBtn');
        var registerGoBack = document.getElementById('registerGoBack');
        var registerBtn = document.getElementById('registerBtn');
        var loginFirst = document.getElementById('loginFirst');
        var loginSecond = document.getElementById('loginSecond');
        var loginProceedBtn = document.getElementById('loginProceedBtn');
        var loginGoBack = document.getElementById('loginGoBack');
        var emailGoBack = document.getElementById('emailGoBack');
        var loginBtn = document.getElementById('loginBtn');
        var errorBag = document.getElementById('errorBag');
        var showRegisterStepBtn = document.getElementById('showRegisterStepBtn');
        var showLoginStepBtn = document.getElementById('showLoginStepBtn');
        var viaWhatsappBtn = document.getElementById('viaWhatsappBtn');
        var viaFacebookBtn = document.getElementById('viaFacebookBtn');
        var viaMailBtn = document.getElementById('viaMailBtn');

        var _hideError = function () {
            var inputs = document.getElementsByClassName('step-input');
            var i = 0; l = inputs.length;
            for (i; i < l; i++) {
                inputs[i].classList.remove('error');
            }
            _hide(errorBag);
        };

        var _raiseError = function (data) {
            var inputs = document.getElementsByClassName('step-input');
            var i = 0; l = inputs.length;
            for (i; i < l; i++) {
                inputs[i].classList.add('error');
            }
            var text = [];
            var bag = data.error || data;
            if ('object' === typeof bag) {
                for (i in bag) {
                    text.push(bag[i]);
                    break;
                }
            } else if ('undefined' !== typeof bag) {
                text.push(bag);
            } else {
                text.push(data);
            }
            errorBag.innerHTML = text.join(', ');
            _show(errorBag);
        };

        var appendLinks = function (links) {
            viaWhatsappBtn.setAttribute('href', links.whatsapp);
            viaMailBtn.setAttribute('data-link', links.raw);
            viaFacebookBtn.setAttribute('onclick', 'FB.ui({method:"share",href:"' + links.raw + '"})');
        };

        var prepareLinks = function () {
            _api(
                '{{ route('api.reflink.seller', $seller) }}', {},
                function (response) {
                    appendLinks(response.success);
                }, function () {}
            );
        };

        var toggleBubble = function () {
            var cl = bubble.className;
            if ('close' == cl) {
                bubble.className = '';
                _hide(stepsHolder);
                XD.postMessage({target:_id,width:'120px',height:'90px'}, parent_url, parent);
            } else {
                bubble.className = 'close';
                _show(stepsHolder);
                XD.postMessage({target:_id,width:'335px',height:'600px'}, parent_url, parent);
            }
        };

        var enter = function () {
            _hide(msgHolder);
            _show(stepsOverlay);
            _api(
                '{{ route('api.login') }}',
                {
                    email: document.getElementById('loginEmail').value,
                    password: document.getElementById('loginPassword').value,
                },
                function (response) {
                    prepareLinks();
                    _hideError();
                    _showStep('share');
                    _hide(stepsOverlay);
                },
                function (response) {
                    _raiseError(response);
                    _hide(stepsOverlay);
                    _hide(loginSecond);
                    _show(loginFirst);
                }
            );
        };

        var register = function () {
            _hide(msgHolder);
            _show(stepsOverlay);
            _api(
                '{{ route('api.register') }}',
                {
                    email: document.getElementById('registerEmail').value,
                    password: document.getElementById('registerPassword').value,
                    seller: {{ $seller->id }},
                },
                function (response) {
                    prepareLinks();
                    _hideError();
                    _showStep('share');
                    _hide(stepsOverlay);
                },
                function (response) {
                    _raiseError(response);
                    _hide(stepsOverlay);
                    if ('undefined' !== typeof response.error.email && response.error.email.length) {
                        _hide(registerSecond);
                        _show(registerFirst);
                    }
                }
            );
        };

        bubble.addEventListener('click', toggleBubble);

        loginBtn.addEventListener('click', function () {
            enter();
        });

        registerBtn.addEventListener('click', function () {
            register();
        });

        registerProceedBtn.addEventListener('click', function () {
            _hideError();
            var email = document.getElementById('registerEmail').value;
            if (!email.length) {
                _raiseError('E-Mail Adresse muss ausgefüllt sein.');
            } else if (!_validateEmail(email)) {
                _raiseError('E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
            } else {
                _show(registerSecond);
                _hide(registerFirst);
            }
        });

        loginProceedBtn.addEventListener('click', function () {
            _hideError();
            var email = document.getElementById('loginEmail').value;
            if (!email.length) {
                _raiseError('E-Mail Adresse muss ausgefüllt sein.');
            } else if (!_validateEmail(email)) {
                _raiseError('E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
            } else {
                _show(loginSecond);
                _hide(loginFirst);
            }
        });

        registerGoBack.addEventListener('click', function () {
            _hideError();
            _hide(registerSecond);
            _show(registerFirst);
        });

        loginGoBack.addEventListener('click', function () {
            _hideError();
            _hide(loginSecond);
            _show(loginFirst);
        });

        emailGoBack.addEventListener('click', function () {
            _hideError();
        });

        showRegisterStepBtn.addEventListener('click', function () {
            _hideError();
        });

        showLoginStepBtn.addEventListener('click', function () {
            _hideError();
        });

        emailSendBtn.addEventListener('click', function () {
            _hideError();
            var email = document.getElementById('emailEmail').value;
            if (!email.length) {
                _raiseError('E-Mail Adresse muss ausgefüllt sein.');
            } else if (!_validateEmail(email)) {
                _raiseError('E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
            } else {
                _isLogged(function () {
                    _hide(msgHolder);
                    _show(stepsOverlay);
                    _hide(stepsCloseBtn);
                    _api('{{ route('api.reflink.share-email') }}', {
                        email: document.getElementById('emailEmail').value,
                        link: viaMailBtn.getAttribute('data-link'),
                    }, function (response) {
                        _showStep('thanks');
                        document.getElementById('emailEmail').value = '';
                    }, function (error) {
                        _showStep('shareEmail');
                        _raiseError(error);
                    });
                }, function () {
                    _showStep('register');
                });
            }
        });

        _isLogged(function () {
            _showStep('share');
        }, function () {
            _showStep('register');
        });
    });
</script>