<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="{{ asset('css/plugins/fontawesome/all.min.css') }}">
</head>
@include('widgets.embed.invite.css')
<body>
    <div class="noselect">
        <div id="bubble">
            <svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 841.89 595.28">
                <path id="bubbleBtn" fill="{{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }}" stroke="null" d="m385.890745,418.03023c401.844059,0 356.895059,119.864681 371.877378,162.09018c0.3126,2.161638 80.334078,-431.784179 81.42307,-456.301815c0,-5.107841 24.493119,-111.287594 -100.375203,-111.287594c-124.866279,0 -585.679339,0.022474 -585.679339,0.022474s-53.201228,-0.022474 -62.403514,-0.022474c-32.520601,0 -89.857137,3.001367 -89.857137,123.162303c0.596596,2.212717 3.781845,145.616371 34.98871,219.680064c28.207541,74.063693 109.769544,60.78535 116.372961,62.656863" />
            </svg>
            <span id="bubbleText">Freunde werben</span>
        </div>
        <div id="stepsHolder">
            <div id="stepsCloseBtn"></div>
            <div id="stepsHeader">
                <div id="sellerLogo"><img src="{{ route('get-userpic', $seller) }}"></div>
                <div id="introTextHolder">
                    <div id="introTextTop">
                        <strong>Empfehle</strong> uns jetzt an Deine Freunde!
                    </div>
                    <div id="introTextBottom">
                        Wir belohnen Dich mit einer <strong>Prämie!</strong>
                    </div>
                </div>
                <div id="dealHolder">
                    @if ( \App\CouponTemplate::TYPE_NONE !== $deal->type_provision )
                    <div id="dealProvision">
                        <div class="small">Prämie</div>
                        <div class="smallest">für Dich</div>
                        <div class="big">{{ $deal->present()->provision_agent_invite }}</div>
                    </div>
                    @endif
                    <div id="dealCashback">
                        <div class="small">Cashback</div>
                        <div class="smallest">für Freunde</div>
                        <div class="big">{{ $deal->present()->discount_consumer_invite }}</div>
                    </div>
                </div>
            </div>
            <div id="stepsBody">
                @include('widgets.embed.steps.login')
                @include('widgets.embed.steps.register')
                @include('widgets.embed.steps.share')
                @include('widgets.embed.steps.share-email')
                @include('widgets.embed.steps.thanks')
                @include('widgets.embed.steps.blank')
            </div>
            <div id="stepsFooter">
                <a target="_blank" class="infolink" href="{{ route('agb') }}">AGB</a>
                <a target="_blank" class="infolink" href="{{ route('privacy') }}">Datenschutzerklärung</a>
                <div id="poweredBy">
                    <a target="_blank" href="{{ route('home') }}">
                        <span>Freundlichst empfohlen mit</span>
                        <img src="{{ asset('img/logo_200x56.png') }}"></a>
                </div>
            </div>
            <div id="errorBag"></div>
            <div id="msgHolder">
                <div id="msgTitle"></div>
                <div id="msgText"></div>
                <div id="msgCloseBtn" class="round-btn"><i class="fas fa-times"></i></div>
            </div>
            <div id="stepsOverlay"></div>
        </div>
    </div>
</body>
@include('widgets.embed.invite.js')
</html>