<style>
    @font-face {
        font-family: 'Roboto';
        font-style: normal;
        font-weight: 400;
        src: url({{ asset('fonts/Roboto-Regular.ttf') }});
    }
    html, body {
        margin: 0;
        padding: 0;
        font-family: Segoe UI;
    }
    .noselect {
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -khtml-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
    }
    #bubble {
        width: 120px;
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        text-align: center;
        font-size: 20px;
        padding-top: 5px;
        cursor: pointer;
        position: absolute;
        bottom: 0;
        right: 0;
        transition: 0.4s all;
    }
    #bubble i {
        display: none;
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        font-size: 30px;
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        text-align: center;
        line-height: 50px;
    }
    #bubble:hover #bubbleText {
        color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
    }
    #bubble:hover #bubbleBtn {
        fill: {{ $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h') }};
    }
    #bubble img {
        max-width: 100%;
    }
    #bubbleText {
        position: absolute;
        top: 12px;
        line-height: 20px;
        left: 0;
        display: inline-block;
        height: 100%;
        width: 100%;
        text-align: center;
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        transition: 0.4s all;
    }
    #bubble.close {
        background: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        height: 50px;
        width: 50px;
        border-radius: 50px;
        padding: 0;
        overflow: hidden;
        transition: 0.4s all;
    }
    #bubble.close #bubbleBtn {
        display: none;
    }
    #bubble:before {
        display: none;
    }
    #bubble:after {
        display: none;
    }
    #bubble.close:before {
        display: block;
        content: '';
        position: absolute;
        height: 30px;
        width: 0;
        border: 1px solid {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        top: 9px;
        left: 23px;
        transform: rotate(-45deg);
        transition: 0.4s all;
    }
    #bubble.close:after {
        display: block;
        content: '';
        position: absolute;
        height: 30px;
        width: 0;
        border: 1px solid {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        top: 9px;
        left: 23px;
        transform: rotate(45deg);
        transition: 0.4s all;
    }
    #bubble.close i {
        display: inline-block;
    }
    #bubble.close:hover i {
        color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
    }
    #bubble.close:hover {
        background: {{ $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h') }};
    }
    #bubble.close:hover:before {
        border-color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
    }
    #bubble.close:hover:after {
        border-color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
    }
    #bubble.close #bubbleText {
        display: none;
    }
    #stepsHolder {
        display: none;
        border: 1px solid {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        border-radius: 4px;
        width: 328px;
        height: 538px;
        background: #fff;
        position: relative;
        overflow: hidden;
        -webkit-box-shadow: 2px 2px 5px 0px rgba(0,0,0,0.75);
        -moz-box-shadow: 2px 2px 5px 0px rgba(0,0,0,0.75);
        box-shadow: 2px 2px 5px 0px rgba(0,0,0,0.75);
    }
    #stepsFooter {
        position: absolute;
        bottom: 10px;
        height: 20px;
        line-height: 20px;
        width: 100%;
        padding-left: 10px;
    }
    #stepsFooter a.infolink {
        font-size: 9px;
        margin: 0 2px;
        color: inherit;
        text-decoration: none;
    }
    #poweredBy {
        position: absolute;
        top: 0;
        right: 20px;
        height: 20px;
        line-height: 20px;
    }
    #poweredBy a {
        font-size: 9px;
        color: inherit;
        text-decoration: none;
    }
    #poweredBy img {
        max-height: 100%;
    }
    #poweredBy span {
        vertical-align: text-bottom;
    }
    #stepsHeader {
        min-height: 380px;
    }
    #sellerLogo {
        height: 80px;
        line-height: 80px;
        padding: 15px 0;
        text-align: center;
    }
    #sellerLogo img {
        max-height: 100%;
        vertical-align: middle;
    }
    #introTextHolder {
        width: 90%;
        margin: 0 auto;
        padding: 4px;
        background: #f4f4f4;
        border-radius: 10px;
        font-size: 16px;
        position: relative;
    }
    #introTextHolder:after {
        position: absolute;
        content: '';
        bottom: -25px;
        left: 20px;
        width: 0;
        height: 0;
        border-style: solid;
        border-width: 25px 0 25px 20px;
        border-color: transparent transparent transparent #f4f4f4;
    }
    #introTextTop strong {
        display: inline-block;
        background: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        padding: 2px 5px;
    }
    #introTextBottom {
        margin-top: 10px;
        text-align: right;
    }
    #dealHolder {
        margin-top: 15px;
        text-align: center;
    }
    #dealProvision, #dealCashback {
        width: 144px;
        text-align: center;
        display: inline-block;
        vertical-align: top;
    }
    #dealProvision .big {
        border-right: none;
        margin-right: -4px;
    }
    .big {
        font-size: 32px;
        height: 120px;
        line-height: 100px;
        font-weight: bold;
        border: 1px solid #ccc;
        margin-top: 5px;
    }
    .big img {
        max-height: 100%;
        max-width: 100%;
    }
    #stepsBody {
        position: relative;
    }
    #stepsOverlay {
        display: none;
        position: absolute;
        top: 0;
        left: 0;
        height: 100%;
        width: 100%;
        z-index: 9999;
        background: rgba(255,255,255,0.75);
    }
    #stepsOverlay:after {
        content: '';
        #background: url({{ asset('img/logo_60x60.png') }}) 50% 50% no-repeat;
        position: absolute;
        height: 60px;
        width: 60px;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        -webkit-animation-name: rotate;
        -webkit-animation-duration:2s;
        -webkit-animation-iteration-count:infinite;
        -webkit-animation-timing-function:linear;
        -moz-animation-name: rotate;
        -moz-animation-duration:2s;
        -moz-animation-iteration-count:infinite;
        -moz-animation-timing-function:linear;
    }
    @-webkit-keyframes rotate {
        from {-webkit-transform:rotate(0deg);}
        to {  -webkit-transform:rotate(360deg);}
    }
    @-moz-keyframes rotate {
        from {-moz-transform:rotate(0deg);}
        to {  -moz-transform:rotate(360deg);}
    }
    .round-btn {
        height: 40px;
        line-height: 40px;
        width: 40px;
        border-radius: 20px;
        font-size: 24px;
        background: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        text-align: center;
        cursor: pointer;
        display: inline-block;
        position: relative;
        transition: 0.4s all;
    }
    .round-btn:hover {
        background: {{ $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h') }};
        color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
    }
    .share-btn {
        background: #fff;
        border-radius: 50px;
        font-weight: 500;
        transition: 0.3s;
        display: inline-block;
        line-height: 17px;
        font-size: 13px;
        padding: 7px 10px;
        cursor: pointer;
        text-decoration: none;
    }
    .share-btn span {
        position: absolute;
        bottom: -30px;
        left: 0;
        font-size: 10px;
        width: 100%;
    }
    #shareBtnsHolder {
        height: 120px;
        padding-top: 60px;
    }
    #shareBtnsTitle {
        position: absolute;
        top: 10px;
        width: 288px;
        left: 20px;
        line-height: 10px;
        font-size: 15px;
        color: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }}
    }
    #viaWhatsappBtn {
        border: 1px solid #25D366;
        color: #25D366;
    }
    #viaWhatsappBtn:hover {
        background: #25D366;
        color: #fff;
    }
    #viaMailBtn {
        border: 1px solid #2c2e33;
        color: #2c2e33;
    }
    #viaMailBtn:hover {
        background: #2c2e33;
        color: #fff;
    }
    #viaFacebookBtn {
        border: 1px solid #3b5998;
        color: #3b5998;
    }
    #viaFacebookBtn:hover {
        background: #3b5998;
        color: #fff;
    }
    #viaSMSBtn {
        display: inline-block;
        height: 64px;
        width: 64px;
        background: url({{ asset('img/icons/sms.svg') }}) 50% 50% no-repeat;
        background-size: cover;
    }
    .form-group {
        padding: 5px 25px;
    }
    .form-group label {
        display: inline-block;
    }
    .form-group input[type='text'], .form-group input[type='password'] {
        width: 100%;
        height: 20px;
        line-height: 20px;
    }
    .text-center {
        text-align: center;
    }
    .btn {
        display: inline-block;
        padding: 0 5px;
        height: 30px;
        line-height: 30px;
        background: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        cursor: pointer;
        text-decoration: none;
        transition: 0.4s all;
        text-align: center;
        vertical-align: middle;
    }
    .btn-big {
        height: 40px;
        line-height: 40px;
        width: 100%;
        padding: 0;
        font-size: 24px;
    }
    .btn:hover {
        background: {{ $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h') }};
        color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
        transform: skew(-3deg);
    }
    .btn-gray {
        background-color: grey;
        color: #fff;
    }
    .btn-gray:hover {
        background-color: darkgrey;
        color: #fff;
    }
    .step {
        display: none;
    }
    #stepsCloseBtn {
        display: none;
    }
    #msgHolder {
        display: none;
        position: absolute;
        top: 0;
        left: 0;
        width: 328px;
        height: 118px;
        z-index: 15;
        text-align: center;
    }
    #msgTitle {
        font-size: 16px;
        font-weight: bold;
        margin: 30px 0 10px;
    }
    #msgText {
        font-size: 14px;
        padding: 0 10px;
    }
    #msgCloseBtn {
        position: absolute;
        top: 10px;
        right: 10px;
    }
    #msgHolder.error {
        color: #721c24;
        background: #f8d7da;
    }
    #msgHolder.success {
        color: #155724;
        background: #d4edda;
    }
	#stepShare {
		padding: 0px 10px;
	}
    #stepLogin p strong {
        font-size: 20px;
    }
    label[for="loginCheckbox"] {
        font-size: 9px;
    }
    #recommendMoreBtn {
        font-size: 24px;
        color: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        margin: 5px 0;
        cursor: pointer;
    }
    #recomaLink {
        color: inherit;
        font-size: 14px;
    }
    .smallest {
        font-size: 12px;
    }
    .stepHeading {
        color: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        font-size: 14px;
    }
    .stepFooter {
        font-size: 12px;
        padding: 0 20px;
        line-height: 12px;
    }
    .stepFooter span {
        text-decoration: underline;
        cursor: pointer;
    }
    .stepFooter a {
        color: inherit;
    }
    .stepInputHolder {
        padding: 0 20px;
        margin: 18px 0;
        position: relative;
    }
    .step-input {
        width: 276px;
        padding: 0 5px;
        height: 40px;
        border-radius: 3px;
        line-height: 40px;
        font-size: 18px;
        box-shadow: 0 1px 3px 0px rgba(0, 0, 0, 0.06);
        border: 1px solid #dbdbdb;
        outline: none;
    }
    .step-input.error {
        border: 1px solid red;
        color: darkred;
    }
    .input-btn {
        position: absolute;
        top: 1px;
        right: 21px;
        width: 60px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        background: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        cursor: pointer;
        transition: 0.4s all;
        font-size: 30px;
        border-radius: 0 2px 2px 0;
    }
    .input-btn:hover {
        background: {{ $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h') }};
        color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
    }
    .input-btn i {
        padding-left: 6px;
    }
    #registerSecond, #loginSecond {
        display: none;
    }
    .step-back {
        font-size: 12px;
        cursor: pointer;
        display: inline-block;
        position: absolute;
        bottom: -14px;
        right: 21px;
        width: 60px;
        text-align: center;
        color: #555;
    }
    #dealCashback .value, #dealProvision .value {
        font-size: 50px;
        vertical-align: middle;
    }
    #dealCashback .unit, #dealProvision .unit {
        font-size: 20px;
        position: absolute;
        margin-top: -10px;
    }
    #thanksTitle {
        position: relative;
        font-size: 13px;
    }
    #thanksTitle p {
        margin: 0;
        padding: 0;
    }
    #thanksImg {
        position: absolute;
        top: -3px;
        right: -10px;
        width: 60px;
        height: 60px;
    }
    #errorBag {
        position: absolute;
        z-index: 10;
        top: 460px;
        text-decoration: underline;
        left: 20px;
        font-size: 10px;
        color: darkred;
    }
</style>