<script>
    @include('widgets.embed.partials.xd')

    window.fbAsyncInit = function() {
        FB.init({
            appId            : {{ config('services.facebook.app_id') }},
            autoLogAppEvents : true,
            xfbml            : true,
            version          : 'v3.2'
        });
    };

    (function(d, s, id){
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) {return;}
        js = d.createElement(s); js.id = id;
        js.src = "https://connect.facebook.net/en_US/sdk.js";
        fjs.parentNode.insertBefore(js, fjs);
    }(document, 'script', 'facebook-jssdk'));

    document.addEventListener("DOMContentLoaded", function() {
        @include('widgets.embed.partials.js-common')

        var _id = 'recoma-deals-widget';
        var _action = null;
        var _deal = 0;
        var shareLinks = [];

        var stepsHolder = document.getElementById('stepsHolder');
        var dealCashbackBtns = document.getElementsByClassName("dealCashbackBtn");
        var dealShareBtns = document.getElementsByClassName("dealShareBtn");
        var dealGetCashbackBtns = document.getElementsByClassName("dealGetCashbackBtn");
        var infoCashback = document.getElementsByClassName("infoCashback");
        var infoProvision = document.getElementsByClassName("infoProvision");
        var registerFirst = document.getElementById('registerFirst');
        var registerSecond = document.getElementById('registerSecond');
        var registerBtn = document.getElementById('registerBtn');
        var loginFirst = document.getElementById('loginFirst');
        var loginSecond = document.getElementById('loginSecond');
        var loginBtn = document.getElementById('loginBtn');
        var stepsCloseBtn = document.getElementById('stepsCloseBtn');
        var stepsOverlay = document.getElementById('stepsOverlay');
        var cashbackGifts = document.querySelectorAll('.deal-cashback .deal-gift');
        var provisionGifts = document.querySelectorAll('.deal-provision .deal-gift');
        var msgHolder = document.getElementById('msgHolder');
        var dealsCloseBtn = document.getElementById('dealsCloseBtn');
        var couponCode = document.getElementById('couponCode');
        var couponBarcode = document.getElementById('couponBarcode');
        var shareWhatsappBtn = document.getElementById('viaWhatsappBtn');
        var shareEmailBtn = document.getElementById('shareEmailBtn');
        var shareFacebookBtn = document.getElementById('viaFacebookBtn');

        var _actions = {
            'cashback' : function () {
                getCashback();
            },
            'confirmCashback' : function () {
                confirmCashback();
            },
            'confirmShare' : function () {
                confirmShare();
            },
            'share' : function () {
                _hide(stepsHolder);
                _hide(msgHolder);
            },
        };

        var processAction = function () {
            if (null !== _action) {
                _actions[_action]();
            }
        };

        var moveControls = function (el) {
            var p = el.closest('.deal');
            _deal = p.getAttribute('data-deal');
            p.appendChild(stepsHolder);
            p.appendChild(msgHolder);
        };

        var doAction = function (el, action, onSuccess) {
            if (!_requestInProcess) {
                _action = action;
                moveControls(el);
                _show(stepsHolder);
                _isLogged(function () {
                    onSuccess();
                }, function () {
                    _showStep('register');
                });
            }
        };

        var getCashbackBtnCick = function () {
            doAction(this, 'cashback', getCashback);
        };

        var confirmCashback = function () {
            _showStep('confirmCashback');
        };

        var confirmShare = function () {
            prepareShareBtns();
            _showStep('confirmShare');
        };

        var applyCashbackInfo = function (el) {
            var p = el.closest('.deal');
            var cb = p.getElementsByClassName('deal-cashback')[0];
            var x = stepsHolder.getElementsByClassName('stepInfoProfit');
            var l = x.length;
            var i = 0;
            for (i; i < l; i++) {
                x[i].innerHTML = '';
                x[i].appendChild(cb.cloneNode(true));
            }
            _show(infoCashback);
            _hide(infoProvision);
        };

        var applyProvisionInfo = function (el) {
            var p = el.closest('.deal');
            var cb = p.getElementsByClassName('deal-provision')[0];
            if ('undefined' !== typeof cb) {
                var x = stepsHolder.getElementsByClassName('stepInfoProfit');
                var l = x.length;
                var i = 0;
                for (i; i < l; i++) {
                    x[i].innerHTML = '';
                    x[i].appendChild(cb.cloneNode(true));
                }
            }
            _show(infoProvision);
            _hide(infoCashback);
        };

        var cashbackBtnCick = function () {
            applyCashbackInfo(this);
            doAction(this, 'confirmCashback', confirmCashback);
        };

        var appendLinks = function (links) {
            shareWhatsappBtn.setAttribute('href', links.whatsapp);
            shareEmailBtn.setAttribute('data-link', links.raw);
            shareFacebookBtn.setAttribute('onclick', 'FB.ui({method:"share",href:"' + links.raw + '"})');
        };

        var prepareLinks = function () {
            var url = '{{ route('api.reflink.deal', '%deal%') }}';
            _api(
                url.replace('%deal%', _deal), {},
                function (response) {
                    shareLinks[_deal] = response.success;
                    appendLinks(response.success);
                }, function () {}
            );
        };

        var prepareShareBtns = function () {
            if ('undefined' !== typeof shareLinks[_deal]) {
                appendLinks(shareLinks[_deal]);
            } else {
                prepareLinks();
            }
        };

        var shareBtnClick = function () {
            applyProvisionInfo(this);
            doAction(this, 'confirmShare', confirmShare);
        };

        var enter = function () {
            _hide(msgHolder);
            _show(stepsOverlay);
            _api(
                '{{ route('api.login') }}',
                {
                    email: document.getElementById('loginEmail').value,
                    password: document.getElementById('loginPassword').value,
                },
                function (response) {
                    processAction();
                    _hide(stepsOverlay);
                    _show(stepsCloseBtn);
                },
                function (response) {
                    _showError(response);
                    _hide(stepsOverlay);
                    _hide(loginSecond);
                    _show(loginFirst);
                }
            );
        };

        var register = function () {
            _hide(msgHolder);
            _show(stepsOverlay);
            _api(
                '{{ route('api.register') }}',
                {
                    email: document.getElementById('registerEmail').value,
                    password: document.getElementById('registerPassword').value,
                    seller: {{ $seller->id }},
                },
                function (response) {
                    processAction();
                    _hide(stepsOverlay);
                    _show(stepsCloseBtn);
                },
                function (response) {
                    _showError(response);
                    _hide(stepsOverlay);
                    if ('undefined' !== typeof response.error.email && response.error.email.length) {
                        _hide(registerSecond);
                        _show(registerFirst);
                    }
                }
            );
        };

        var getCashback = function () {
            _hide(msgHolder);
            _showStep('blank');
            _show(stepsOverlay);
            _hide(stepsCloseBtn);
            var url = '{{ route('api.get-cashback', ['deal' => '%deal%']) }}';
            _api(
                url.replace('%deal%', _deal), {}, function (response) {
                    couponCode.innerText = response.success.code;
                    couponBarcode.innerHTML = '<img src="data:image/png;base64,' + response.success.barcode + '">';
                    _showStep('couponCode');
                }, function (error) {
                    _showError(error);
                    _hide(stepsHolder);
                }
            );
        };

        var sendMail = function () {
            var email = document.getElementById('shareEmailInput').value;
            if (!email.length) {
                _showError('E-Mail Adresse muss ausgefüllt sein.');
            } else if (!_validateEmail(email)) {
                _showError('E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
            } else {
                _show(stepsHolder);
                _isLogged(function () {
                    _hide(msgHolder);
                    _showStep('blank');
                    _show(stepsOverlay);
                    _hide(stepsCloseBtn);
                    _api(
                        '{{ route('api.reflink.share-email') }}', {
                            email: email,
                            link: shareEmailBtn.getAttribute('data-link'),
                        }, function (response) {
                            _showStep('shareSuccess');
                            document.getElementById('mailInput').value = '';
                        }, function (error) {
                            _showStep('shareEmail');
                            _showError(error);
                        }
                    );
                }, function () {
                    _showStep('register');
                });
            }
        };

        var i = 0, l = dealGetCashbackBtns.length;
        for (i; i < l; i++) {
            dealGetCashbackBtns[i].addEventListener('click', getCashbackBtnCick);
        }

        var i = 0, l = dealCashbackBtns.length;
        for (i; i < l; i++) {
            dealCashbackBtns[i].addEventListener('click', cashbackBtnCick);
        }

        var i = 0, l = dealShareBtns.length;
        for (i; i < l; i++) {
            dealShareBtns[i].addEventListener('click', shareBtnClick);
        }

        loginBtn.addEventListener('click', function () {
            enter();
        });

        registerBtn.addEventListener('click', function () {
            register();
        });

        stepsCloseBtn.addEventListener('click', function () {
            _hide(stepsHolder);
            _hide(msgHolder);
        });

        shareEmailBtn.addEventListener('click', sendMail);

        var i = 0; l = cashbackGifts.length;
        for (i; i < l; i++) {
            cashbackGifts[i].addEventListener('mouseenter', function () {
                var p = this.closest('.deal');
                p.getElementsByClassName('deal-cashback-gift')[0].classList.add('opened');
            });
            cashbackGifts[i].addEventListener('mouseleave', function () {
                var p = this.closest('.deal');
                p.getElementsByClassName('deal-cashback-gift')[0].classList.remove('opened');
            });
        }

        var i = 0; l = provisionGifts.length;
        for (i; i < l; i++) {
            provisionGifts[i].addEventListener('mouseenter', function () {
                var p = this.closest('.deal');
                p.getElementsByClassName('deal-provision-gift')[0].classList.add('opened');
            });
            provisionGifts[i].addEventListener('mouseleave', function () {
                var p = this.closest('.deal');
                p.getElementsByClassName('deal-provision-gift')[0].classList.remove('opened');
            });
        }

        dealsCloseBtn.addEventListener('click', function () {
            XD.postMessage({target:_id, action:'hide'}, parent_url, parent);
        });
    });
</script>