<style>
    @font-face {
        font-family: 'Roboto';
        font-style: normal;
        font-weight: 400;
        src: url({{ asset('fonts/Roboto-Regular.ttf') }});
    }
    html, body {
        margin: 0;
        padding: 0;
        font-family: Segoe UI;
        background: #fff;
        height: 100%;
    }
    .text-center {
        text-align: center;
    }
    .noselect {
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -khtml-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
    }
    #dealsOuter {
        display: table;
        width: 100%;
        height: 100%;
    }
    #dealsHolder {
        display: table-cell;
        vertical-align: middle;
    }
    #dealsList {
        max-width: 800px;
        text-align: left;
        padding: 0 10px;
        margin: 0 auto;
    }
    #dealsCloseBtn {
        position: fixed;
        top: 15px;
        right: 15px;
        border: 1px solid #555;
        border-radius: 40px;
        color: #555;
        height: 40px;
        line-height: 40px;
        width: 40px;
        background: #fff;
        cursor: pointer;
        text-align: center;
        font-size: 30px;
        transition: 0.4s all;
        z-index: 1010;
    }
    #dealsCloseBtn:hover {
        border: 1px solid #000;
        color: #000;
    }
    #mailHolder {
        display: none;
    }
    #msgHolder {
        display: none;
        position: absolute;
        top: 0;
        left: 0;
        height: 100%;
        width: 100%;
        z-index: 1006;
        background: #f4f4f4;
    }
    #msgHolder.error {
        color: #721c24;
        background: #f8d7da;
    }
    #msgHolder.success {
        color: #155724;
        background: #d4edda;
    }
    #msgCloseBtn {
        position: absolute;
        top: 50%;
        left: 50%;
        margin-top: 20px;
        margin-left: -47px;
    }
    #msgTitle {
        padding: 20px 0;
        text-align: center;
        font-size: 18px;
        font-weight: 500;
    }
    #msgText {
        position: absolute;
        height: 30px;
        line-height: 30px;
        text-align: center;
        width: 100%;
        top: 0;
        bottom: 0;
        left: 0;
        right: 0;
        margin: auto;
        overflow: hidden;
    }
    #couponCode {
        text-transform: uppercase;
        letter-spacing: 20px;
        padding-left: 20px;
        font-size: 16px;
        color: #000;
        margin-bottom: 10px;
        display: inline-block;
    }

    .stepInfoText {
        font-size: 18px;
        height: 30px;
        font-weight: 500;
        line-height: 30px;
    }
    #stepConfirmShare {
        padding: 70px 0;
    }
    #shareBtnsHolder {
        margin-top: 20px;
    }
    #registerBtnHolder {
        margin: 13px 0;
    }
    #loginBtnHolder {
        margin: 13px 0;
    }
    .stepFooter {
        font-size: 12px;
    }
    .stepFooter a, .stepFooter span[data-show-step] {
        color: #418ACA;
        text-decoration: none;
        cursor: pointer;
    }
    #stepConfirmCashback .stepInfo {
        margin-bottom: 30px;
    }
    #stepConfirmCashback {
        padding: 60px 0;
    }
    #couponCodeBtnsHolder {
        margin-top: 10px;
    }

    .powered-by {
        margin: 30px 0;
        height: 30px;
        line-height: 30px;
        text-align: center;
    }
    .powered-by a {
        display: inline-block;
        vertical-align: middle;
    }
    .powered-by span {
        display: inline-block;
        vertical-align: top;
    }
    #recomaLogo {
        height: 30px;
    }

    .deal {
        position: relative;
    }

    .deals-list-container h4 {
        background-color: #fff;
        border-bottom: 1px solid #418ACA;
        padding: 30px;
        border-radius: 4px 4px 0 0;
        position: relative;
        z-index: 10;
        display: block;
        font-weight: 500;
        margin: 30px 0;
        color: #418ACA;
    }

    .deals-list-container h4:after {
        width: 100%;
        height: 100%;
        border-radius: 4px 4px 0 0;
        display: block;
        position: absolute;
        top: 0;
        left: 0;
        content: "";
        background-color: #418ACA;
        opacity: 0.05;
        z-index: 9;
    }

    .deal-item-container {
        display: block;
        height: 100%;
        width: 100%;
        border-radius: 4px;
        transform: translate3d(0,0,0);
        transition: transform 0.3s;
        background-color: #f4f4f4;
        margin-bottom: 25px;
    }

    .deal-item {
        display: flex;
        background-color: transparent;
        height: 220px;
        border-radius: 4px 4px 0 0;
        position: relative;
        background-size: cover;
        background-repeat: no-repeat;
        background-position: 50%;
        overflow: hidden;
    }

    .deal-item-image {
        min-height: 200px;
        flex: 2;
        height: 100%;
        overflow: hidden;
        border-radius: 4px 0 0 4px;
        position: relative;
    }

    .deal-item-image:before {
        content: "";
        width: 100%;
        height: 100%;
        position: absolute;
        z-index: 1;
        display: block;
        background-color: #272729;
        opacity: 0.2;
    }

    .deal-item-image img {
        border-radius: 0;
        object-fit: cover;
        height: 100%;
        width: 100%;
    }

    .deal-item-content {
        flex: 5;
        position: relative;
        bottom: 0;
        left: 0;
        padding: 0;
        width: 100%;
        z-index: 50;
        box-sizing: border-box;
    }

    .deal-item-content h3 {
        position: absolute;
        top: 20px;
        left: 35px;
        font-size: 20px;
        font-weight: 500;
        margin: 0;
        line-height: 31px;
        color: #2c2e33;
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
        max-width: 85%;
    }

    .deal-item-inner {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        left: 35px;
        padding-right: 120px;
    }

    .deal-share {
        position: absolute;
        bottom: 10px;
        left: 35px;
        height: 33px;
        line-height: 31px;
        z-index: 101;
        padding: 0 10px;
        font-size: 13px;
        font-weight: 500;
        background: #fff;
        color: #f18407;
        border: 1px solid #f18407;
        border-radius: 50px;
        display: inline-block;
        transition: all 0.2s ease-in-out;
        cursor: pointer;
        overflow: hidden;
    }

    .deal-share:hover {
        background: #f18407;
        color: #fff;
    }

    .deal-activate {
        position: absolute;
        bottom: 10px;
        right: 10px;
        z-index: 101;
        height: 33px;
        line-height: 31px;
        padding: 0 10px;
        font-size: 13px;
        font-weight: 500;
        background: #fff;
        color: #418ACA;
        border: 1px solid #418ACA;
        border-radius: 50px;
        display: inline-block;
        transition: all 0.2s ease-in-out;
        cursor: pointer;
        overflow: hidden;
    }

    .deal-activate:hover {
        background: #418ACA;
        color: #fff;
    }

    .btn {
        display: inline-block;
        padding: 0 5px;
        height: 30px;
        line-height: 30px;
        background: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        cursor: pointer;
        text-decoration: none;
        transition: 0.4s all;
    }
    .btn-big {
        height: 40px;
        line-height: 40px;
        width: 300px;
        padding: 0;
        font-size: 24px;
        text-align: center;
    }
    .btn:hover {
        background: {{ $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h') }};
        color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
        transform: skew(-3deg);
    }
    .btn-gray {
        background-color: grey;
        color: #fff;
    }
    .btn-gray:hover {
        background-color: darkgrey;
    }
    #stepsHolder {
        display: none;
        position: absolute;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 1001;
        background: #f4f4f4;
        border-radius: 4px;
    }
    #stepsOverlay {
        position: absolute;
        top: 0;
        left: 0;
        height: 100%;
        width: 100%;
        background: rgba(244, 244, 244, 0.9);
        z-index: 1005;
        display: none;
    }
    .sk-fading-circle {
        width: 50px;
        height: 50px;
        position: absolute;
        top: 50%;
        left: 50%;
        margin-top: -25px;
        margin-left: -25px;
    }
    .sk-fading-circle .sk-circle {
        width: 100%;
        height: 100%;
        position: absolute;
        left: 0;
        top: 0;
    }
    .sk-fading-circle .sk-circle:before {
        content: '';
        display: block;
        margin: 0 auto;
        width: 15%;
        height: 15%;
        background-color: #418ACA;
        border-radius: 100%;
        -webkit-animation: sk-circleFadeDelay 1.2s infinite ease-in-out both;
        animation: sk-circleFadeDelay 1.2s infinite ease-in-out both;
    }
    .sk-fading-circle .sk-circle2 {
        -webkit-transform: rotate(30deg);
        -ms-transform: rotate(30deg);
        transform: rotate(30deg);
    }
    .sk-fading-circle .sk-circle3 {
        -webkit-transform: rotate(60deg);
        -ms-transform: rotate(60deg);
        transform: rotate(60deg);
    }
    .sk-fading-circle .sk-circle4 {
        -webkit-transform: rotate(90deg);
        -ms-transform: rotate(90deg);
        transform: rotate(90deg);
    }
    .sk-fading-circle .sk-circle5 {
        -webkit-transform: rotate(120deg);
        -ms-transform: rotate(120deg);
        transform: rotate(120deg);
    }
    .sk-fading-circle .sk-circle6 {
        -webkit-transform: rotate(150deg);
        -ms-transform: rotate(150deg);
        transform: rotate(150deg);
    }
    .sk-fading-circle .sk-circle7 {
        -webkit-transform: rotate(180deg);
        -ms-transform: rotate(180deg);
        transform: rotate(180deg);
    }
    .sk-fading-circle .sk-circle8 {
        -webkit-transform: rotate(210deg);
        -ms-transform: rotate(210deg);
        transform: rotate(210deg);
    }
    .sk-fading-circle .sk-circle9 {
        -webkit-transform: rotate(240deg);
        -ms-transform: rotate(240deg);
        transform: rotate(240deg);
    }
    .sk-fading-circle .sk-circle10 {
        -webkit-transform: rotate(270deg);
        -ms-transform: rotate(270deg);
        transform: rotate(270deg);
    }
    .sk-fading-circle .sk-circle11 {
        -webkit-transform: rotate(300deg);
        -ms-transform: rotate(300deg);
        transform: rotate(300deg);
    }
    .sk-fading-circle .sk-circle12 {
        -webkit-transform: rotate(330deg);
        -ms-transform: rotate(330deg);
        transform: rotate(330deg);
    }
    .sk-fading-circle .sk-circle2:before {
        -webkit-animation-delay: -1.1s;
        animation-delay: -1.1s;
    }
    .sk-fading-circle .sk-circle3:before {
        -webkit-animation-delay: -1s;
        animation-delay: -1s;
    }
    .sk-fading-circle .sk-circle4:before {
        -webkit-animation-delay: -0.9s;
        animation-delay: -0.9s;
    }
    .sk-fading-circle .sk-circle5:before {
        -webkit-animation-delay: -0.8s;
        animation-delay: -0.8s;
    }
    .sk-fading-circle .sk-circle6:before {
        -webkit-animation-delay: -0.7s;
        animation-delay: -0.7s;
    }
    .sk-fading-circle .sk-circle7:before {
        -webkit-animation-delay: -0.6s;
        animation-delay: -0.6s;
    }
    .sk-fading-circle .sk-circle8:before {
        -webkit-animation-delay: -0.5s;
        animation-delay: -0.5s;
    }
    .sk-fading-circle .sk-circle9:before {
        -webkit-animation-delay: -0.4s;
        animation-delay: -0.4s;
    }
    .sk-fading-circle .sk-circle10:before {
        -webkit-animation-delay: -0.3s;
        animation-delay: -0.3s;
    }
    .sk-fading-circle .sk-circle11:before {
        -webkit-animation-delay: -0.2s;
        animation-delay: -0.2s;
    }
    .sk-fading-circle .sk-circle12:before {
        -webkit-animation-delay: -0.1s;
        animation-delay: -0.1s;
    }
    @-webkit-keyframes sk-circleFadeDelay {
        0%, 39%, 100% { opacity: 0; }
        40% { opacity: 1; }
    }
    @keyframes sk-circleFadeDelay {
        0%, 39%, 100% { opacity: 0; }
        40% { opacity: 1; }
    }
    #stepsCloseBtn {
        position: absolute;
        top: 10px;
        right: 10px;
        height: 30px;
        cursor: pointer;
        width: 30px;
        line-height: 30px;
        font-size: 30px;
        color: #418ACA;
        text-align: center;
    }
    @-webkit-keyframes rotate {
        from {-webkit-transform:rotate(0deg);}
        to {  -webkit-transform:rotate(360deg);}
    }
    @-moz-keyframes rotate {
        from {-moz-transform:rotate(0deg);}
        to {  -moz-transform:rotate(360deg);}
    }

    .share-btn, .action-btn {
        background: #fff;
        border-radius: 50px;
        font-weight: 500;
        transition: 0.3s;
        display: inline-block;
        line-height: 17px;
        font-size: 13px;
        padding: 7px 10px;
        cursor: pointer;
        text-decoration: none;
    }
    .share-btn span, .action-btn span {
        position: absolute;
        bottom: -30px;
        left: 0;
        font-size: 10px;
        width: 100%;
    }
    .cancel-btn {
        border: 1px solid #555;
        color: #555;
    }
    .cancel-btn:hover {
        color: #fff;
        background: #555;
    }
    #viaWhatsappBtn {
        border: 1px solid #25D366;
        color: #25D366;
    }
    #viaWhatsappBtn:hover {
        background: #25D366;
        color: #fff;
    }
    #viaMailBtn {
        border: 1px solid #2c2e33;
        color: #2c2e33;
    }
    #viaMailBtn:hover {
        background: #2c2e33;
        color: #fff;
    }
    #viaFacebookBtn {
        border: 1px solid #3b5998;
        color: #3b5998;
    }
    #viaFacebookBtn:hover {
        background: #3b5998;
        color: #fff;
    }

    .stepInputHolder {
        margin: 18px auto;
        position: relative;
        width: 90%;
        max-width: 350px;
    }
    .step-input {
        width: 100%;
        padding: 0 5px;
        height: 40px;
        border-radius: 4px;
        line-height: 40px;
        font-size: 18px;
        box-shadow: 0 1px 3px 0px rgba(0, 0, 0, 0.06);
        border: 1px solid #dbdbdb;
        outline: none;
    }
    .step-input.error {
        border: 1px solid red;
        color: darkred;
    }
    .input-btn {
        position: absolute;
        top: 1px;
        right: -11px;
        width: 60px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        background: {{ $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg') }};
        color: {{ $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt') }};
        cursor: pointer;
        transition: 0.4s all;
        font-size: 30px;
        border-radius: 0 4px 4px 0;
    }
    .input-btn:hover {
        background: {{ $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h') }};
        color: {{ $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h') }};
    }
    .input-btn i {
        padding-left: 6px;
    }

    .thanksImg {
        height: 60px;
    }
    #stepShareSuccess {
        padding: 35px 0;
    }
    .main-btn {
        color: #418ACA;
        border: 1px solid #418ACA;
    }
    .main-btn:hover {
        background: #418ACA;
        color: #fff;
    }
    #stepShareEmail {
        padding: 40px 0;
    }
    #registerEmailHolder, #registerPasswordHolder {
        margin: 5px auto;
    }
    #loginEmailHolder, #loginPasswordHolder {
        margin: 5px auto;
    }
    #shareSuccessBtnsHolder {
        margin-top: 10px;
    }
    #stepCouponCode {
        padding: 8px 0;
    }

    @media (max-width: 800px) {
        .deal-item {
            display: block;
            height: auto;
            padding: 0;
        }
        .deal-item-image {
            min-height: auto;
            flex: 3;
            border-radius: 0;
        }
        .deal-item-image img {
            max-height: 220px;
        }
        .deal-item-image:before {
            max-height: 220px;
        }
        .deal-item-inner {
            position: relative;
            top: auto;
            transform: none;
            left: 0;
            min-height: 80px;
            padding: 60px 35px 0;
        }
        .deal-share {
            bottom: 155px !important;
            left: 10px !important;
        }
        .deal-activate {
            bottom: 155px !important;
            right: 10px !important;
        }

        #stepConfirmShare {
            padding: 140px 0;
        }
        #stepShareSuccess {
            padding: 100px 0;
        }
        #stepShareEmail {
            padding: 110px 0;
        }
        #stepRegister {
            padding-top: 70px;
        }
        #stepLogin {
            padding-top: 70px;
        }
        #registerEmailHolder, #registerPasswordHolder {
            margin: 18px auto;
        }
        #loginEmailHolder, #loginPasswordHolder {
            margin: 18px auto;
        }
        #registerBtnHolder {
            margin: 20px 0 40px;
        }
        #loginBtnHolder {
            margin: 20px 0 40px;
        }
        #stepConfirmCashback {
            padding: 140px 0;
        }
        #stepCouponCode {
            padding: 70px 0;
        }
        #stepCouponCode .stepInfoText {
            margin-bottom: 20px;
        }
    }
</style>