@extends('layouts.home')

@section('title', 'Benutzer Geschenke')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Benutzer Geschenke</h5>
                </div>
                    @if($usersGifts->count())
                        <div id="usersGiftList">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Geschenk</th>
                                        <th>Benutzer</th>
                                        <th>Coupon</th>
                                        <th>Adresse</th>
                                        <th>Status</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($usersGifts as $usersGift)
                                        @include('usersgifts.partials.usersgift', $usersGift)
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <form action="" method="post" style="display: none" id="usersGiftPutForm">
                            {{ csrf_field() }}
                            {{ method_field('PUT') }}
                        </form>
                    @else
                        <p>Keine Benutzer Geschenke</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $(document).ready(function () {
            $('.ugiftMarkAsSent').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                if ( confirm('Bist du sicher? Aktion ist nicht kündbar') ) {
                    $('#usersGiftPutForm')
                        .attr('action', $(this).attr('href'))
                        .submit();
                }
            });
        });
    </script>
@endsection