<div class="ibox float-e-margins">
    <div class="ibox-title">
        <h5>Persönliche Daten</h5>
    </div>
    <div class="ibox-content">
        <div class="form-group{{ $errors->has('salutation') ? ' has-error' : '' }}">
            <label for="salutation" class="col-sm-2 control-label">Anrede*</label>

            <div class="col-sm-10">
                <select name="salutation" size="1" id="salutation" class="form-control" required>
                    <option value="Herr"
                            @if( Auth::user()->salutation == 'Herr') selected="selected" @endif>Herr
                    </option>
                    <option value="Frau"
                            @if( Auth::user()->salutation == 'Frau') selected="selected" @endif>Frau
                    </option>
                </select>
            </div>
        </div>

        <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
            <label for="firstname" class="col-sm-2 control-label">Vorname*</label>

            <div class="col-sm-10">
                <input id="firstname" type="text" class="form-control" name="firstname"
                       value="{{ old('firstname',Auth::user()->firstname) }}">
                @if ($errors->has('firstname'))
                    <span class="help-block">
                        <strong>{{ $errors->first('firstname') }}</strong>
                    </span>
                @endif
            </div>
        </div>

        <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
            <label for="surname" class="col-sm-2 control-label">Nachname*</label>

            <div class="col-sm-10">
                <input id="surname" type="text" class="form-control" name="surname"
                       value="{{ old('surname',Auth::user()->surname) }}">
                @if ($errors->has('surname'))
                    <span class="help-block">
                        <strong>{{ $errors->first('surname') }}</strong>
                    </span>
                @endif
            </div>
        </div>

        @if( !Auth::user()->hasRole('agent'))
            <div class="form-group{{ $errors->has('mobile') ? ' has-error' : '' }}">
                <label for="mobile" class="col-sm-2 control-label">Handynummer</label>

                <div class="col-sm-10">
                    <input id="mobile" type="text" class="form-control" name="mobile"
                           value="{{old('mobile', Auth::user()->mobile) }}">
                    @if ($errors->has('mobile'))
                        <span class="help-block">
                            <strong>{{ $errors->first('mobile') }}</strong>
                        </span>
                    @endif
                </div>
            </div>
        @endif

        <div class="form-group{{ $errors->has('phone') ? ' has-error' : '' }}">
            <label for="phone" class="col-sm-2 control-label">Telefon @if(Auth::user()->hasRole('seller'))*@endif</label>

            <div class="col-sm-10">
                <input id="phone" type="text" class="form-control" name="phone"
                       value="{{ old('phone',Auth::user()->phone) }}">
                @if ($errors->has('phone'))
                    <span class="help-block">
                        <strong>{{ $errors->first('phone') }}</strong>
                    </span>
                @endif
            </div>
        </div>

        @if( Auth::user()->hasRole('agent')||Auth::user()->hasRole('seller'))
            <div class="form-group{{ $errors->has('fax') ? ' has-error' : '' }}">
                <label for="fax" class="col-sm-2 control-label">Fax</label>

                <div class="col-sm-10">
                    <input id="fax" type="text" class="form-control" name="fax"
                           value="{{ old('fax',Auth::user()->fax) }}">
                    @if ($errors->has('fax'))
                        <span class="help-block">
                                    <strong>{{ $errors->first('fax') }}</strong>
                                </span>
                    @endif
                </div>
            </div>
        @endif

        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
            <label for="email" class="col-sm-2 control-label">E-Mail Adresse*</label>

            <div class="col-sm-10">
                <input id="email" type="email" class="form-control" name="email"
                       value="{{ old('email',Auth::user()->email) }}">
                @if ($errors->has('email'))
                    <span class="help-block">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
            </div>
        </div>

        <div class="form-group">
            <label for="email" class="col-md-2 control-label">Benutzerportrait</label>

            <div class="col-xs-12 col-md-10 clearfix text-center ">
                <img data-lightbox="image-1" class="profile-image avatar" id="imgOutput"
                     src="@if(Auth::user()->upload_portrait != ''){{ route('user-portrait', Auth::user()->upload_portrait) }}@else{{ '/img/default.jpg' }}@endif">
            </div>

            <div class="upload col-sm-10 col-sm-offset-2">
                <p>
                    Wählen Sie eine Bilddatei mit Ihrem Profilfoto (*.jpeg, *.jpg, *.png *.gif) von Ihrem Rechner aus:<br>
                    *Maximum 200x200 Pixel
                    <input name="portrait" type="file" size="50" accept="image/*"
                           class="btn btn-primary" id="imgInp">
                </p>
            </div>
        </div>
    </div>
</div>