@extends('layouts.home')

@section('title', 'Benutzerprofil')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div id="user-profile">

                    <div class="profile-bg">

                        <img data-lightbox="image-1" class="profile-image"
                             src="@if($user->upload_portrait != ''){{ route('user-portrait', $user->upload_portrait) }}@else{{ '/img/default.jpg' }}@endif">

                        <div class="profilname"><h2>{{ $user->firstname }} <strong>{{ $user->surname }}</strong></h2>
                            <br>
                        </div>

                    </div>





                    <div class="ibox-content">
                        <div class="col-md-2 left">
                            <h2><i class="fa fa-user"></i> Benutzerprofil</h2>

                            <div class="hr-line-dashed"></div>
                            <div class="email">
                                <h3><i class="fa fa-user"></i> Anrede:</h3>
                            </div>
                            <div class="hr-line-dashed"></div>
                            <div class="email">
                                <h3><i class="fa fa-user"></i> Name:</h3>
                            </div>
                            <div class="hr-line-dashed"></div>
                            <div class="email">
                                <h3><i class="fa fa-building-o"></i> Firma:</h3>
                            </div>
                            <div class="hr-line-dashed"></div>
                            <div class="email">
                                <h3><i class="fa fa-envelope-square"></i> E-Mail:</h3>
                            </div>
                            <div class="hr-line-dashed"></div>
                            <div class="handy">
                                <h3><i class="fa fa-map-marker"></i> Ort, PLZ:</h3>
                            </div>

                        </div>
                        <div class="col-md-5">
                            <h2>Kontaktinformationen und allgemeine Infos</h2>

                            <div class="hr-line-dashed"></div>
                            <div class="title">
                                <p>Herr</p>
                            </div>
                            <div class="hr-line-dashed"></div>
                            <div class="title">
                                <p>{{ $user->firstname }} {{ $user->surname }}</p>
                            </div>
                            <div class="hr-line-dashed"></div>
                            <div class="email">
                                <p><a href="{{ url('/user/account/show/' . $user->account->id) }}">{{ $user->account->company }}</a></p>
                            </div>
                            <div class="hr-line-dashed"></div>
                            <div class="email">
                                <p>{{ $user->email }} </p>
                            </div>
                            <div class="hr-line-dashed"></div>
                            <div class="handy">
                                <p>{{ $user->account->city }}, {{ $user->account->zip }} </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('after-scripts')
    <script type="text/javascript" language="javascript">
        $("textarea").height($("textarea")[0].scrollHeight);
    </script>
@endsection

