@extends('layouts.root')

@section('title','Passwort setzten')

@section('head.links')
    <link href="/css/bootstrap.min.css" rel="stylesheet">
    <link href="/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="/css/animate.css" rel="stylesheet">
    <link href="/css/style.css" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
@endsection

@section('body.class', 'gray-bg')

@section('body')
<div class="middle-box text-center animated fadeInDown">
    <div class="row">
        <div class="">
            <div class="ibox-content">

                <h3 class="font-bold">Willkommen zum RECO.MA Portal</h3>

                <p>
                    1. Bitte setzen Sie ein Passwort um sich im RECO.MA Portal kostenlos zu registrieren
                </p>
                <div class="row">

                    <div class="col-lg-12">
                        <form class="form-horizontal" role="form" method="POST" action="{{ url('/password/set') }}">
                            {{ csrf_field() }}

                            <input type="hidden" name="token" value="{{ $token }}">

                            <div class="form-row {{ $errors->has('email') ? ' has-error' : '' }}">

                                    <input id="email" type="email" class="form-control" name="email" value="{{ $email or old('email') }}" placeholder="Email address">

                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                    @endif
                            </div>

                            <div class="form-row {{ $errors->has('password') ? ' has-error' : '' }}">

                                    <input id="password" type="password" class="form-control" name="password"  placeholder="Passwort">

                                    @if ($errors->has('password'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                    @endif
                            </div>

                            <div class="form-row {{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation"  placeholder="Passwort bestätigen">

                                    @if ($errors->has('password_confirmation'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('password_confirmation') }}</strong>
                                    </span>
                                    @endif
                            </div>
                            <div class="form-row">
                                <label>
                                    <input type="checkbox" id="agb" name="agb" value="agb" required>
                                    Ich stimme den <a href="{{ url('/ea') }}">AGB</a> und <a target="_blank" href="{{ url('/ed') }}">Datenschutzerklärung</a> zu
                                </label>
                                <br>
                                <label>
                                    <input type="checkbox" id="newsletter" name="newsletter" value="true" class="form-group">
                                    <strong>Newsletter anmeldung</strong>
                                </label>
                            </div>

                            <div class="form-row ">
                                <button type="submit" class="btn btn-primary block full-width m-b">Passwort setzen</button>
                            </div>
                            <br> <br>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <hr/>
    <div class="row">
        <div class="m-t">
            <small>RECO.MA © 2017</small>
        </div>
    </div>
</div>
@endsection