@extends('layouts.root')

@section('title','Passwort setzten')

@section('head.links')
    <link href="/css/bootstrap.min.css" rel="stylesheet">
    <link href="/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="/css/animate.css" rel="stylesheet">
    <link href="/css/style.css" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
@endsection

@section('body.class', 'gray-bg')

@section('body')
    <div class="middle-box text-center animated fadeInDown">
        <div class="row">
            <div class="">
                <div class="ibox-content">

                    <h3 class="font-bold">Willkommen zum RECO.MA Portal</h3>

                    <p>
                        1. Bitte geben Sie ihre E-Mail Adresse an und setzen Sie ein Passwort um sich im RECO.MA Portal
                        zu registrieren
                    </p>
                    <div class="row">

                        <div class="col-lg-12">
                            <form class="form-horizontal" role="form" method="POST"
                                  action="{{ url('/registration') }}">
                                {{ csrf_field() }}

                                <input type="hidden" name="token" value="{{ $token }}">

                                <div class="col-md-6">
                                    <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                                        <input id="firstname" type="text" class="form-control" name="firstname"
                                               value="{{ old('firstname') }}"
                                               required>
                                        <label alt="Vorname*" placeholder="Vorname*"></label>

                                        @if ($errors->has('firstname'))
                                            <span class="help-block">
                            <strong>{{ $errors->first('firstname') }}</strong>
                        </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
                                        <input id="surname" type="text" class="form-control" name="surname"
                                               value="{{ old('surname') }}"
                                               required>
                                        <label alt="Nachname*" placeholder="Nachname*"></label>
                                        @if ($errors->has('surname'))
                                            <span class="help-block">
                            <strong>{{ $errors->first('surname') }}</strong>
                                    </span>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-row {{ $errors->has('email') ? ' has-error' : '' }}">

                                    <input id="email" type="email" class="form-control" name="email"
                                           value="{{ $email or old('email') }}" placeholder="Email address*" required>

                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                    @endif
                                </div>

                                <div class="form-row {{ $errors->has('zip') ? ' has-error' : '' }}">

                                    <input id="zip" type="text" class="form-control" name="zip"
                                           value="{{ $zip or old('zip') }}" placeholder="PLZ*">

                                    @if ($errors->has('zip'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('zip') }}</strong>
                                    </span>
                                    @endif
                                </div>

                                <div class="form-row {{ $errors->has('password') ? ' has-error' : '' }}">

                                    <input id="password" type="password" class="form-control" name="password"
                                           placeholder="Passwort*">

                                    @if ($errors->has('password'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                    @endif
                                </div>

                                <div class="form-row {{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                    <input id="password-confirm" type="password" class="form-control"
                                           name="password_confirmation" placeholder="Passwort bestätigen*">

                                    @if ($errors->has('password_confirmation'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('password_confirmation') }}</strong>
                                    </span>
                                    @endif
                                </div>

                                <div class="form-row ">
                                    <button type="submit" class="btn btn-primary block full-width m-b">Speichern
                                    </button>
                                </div>
                                <br> <br>
                            </form>
                            <div class="row">
                                Schon Registriert? Log dich
                                    <a href="{{ url('login') . '/' . $token }}" style="background:none;border:none; margin:0; padding:0;">hier</a>
                                ein!
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <hr/>
        <div class="row">
            <div class="m-t">
                <small>RECO.MA © 2017</small>
            </div>
        </div>
    </div>
@endsection