@extends('layouts.home')

@section('title', 'Profil')

@section('content')
    @if(Auth::user()->hasRole('seller'))
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Alias</h5>
                </div>
                <div class="ibox-content">
                    <form class="form-horizontal" role="form" method="POST" enctype="multipart/form-data" action="{{ route('set-alias') }}">
                        {{ csrf_field() }}
                        <div class="form-group{{ $errors->has('alias') ? ' has-error' : '' }}">
                            <label for="alias" class="col-sm-2 control-label">Alias</label>
                            <div class="col-sm-10">
                                <input id="alias" type="text" class="form-control" name="alias" value="{{ old('alias', Auth::user()->alias) }}" style="text-transform: lowercase">

                                @include('partials.form.error', ['property' => 'alias'])
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label"></label>
                            <div class="col-sm-10">
                                <button class="btn btn-primary" type="submit">Speichern</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    @endif

    <form class="form-horizontal" id="userEditForm" role="form" method="POST" enctype="multipart/form-data"
          action="{{ url('/user/edit/' . Auth::user()->id ) }}">
        {{ csrf_field() }}
        <div class="row">
            <div class="col-md-12">
                @if(Auth::user()->hasRole('seller') && Auth::user()->can('edit account data'))
                    @include('user.account-profile')
                    @include('user.user-profile')
                @else
                    @include('user.user-profile')
                    @include('user.account-profile')
                @endif
            </div>
        </div>

        @if(Auth::user()->hasRole('consumer') || Auth::user()->hasRole('agent') || Auth::user()->hasRole('seller'))
            @can('edit account')
                <div class="row">
                    <div class="col-md-12">
                        <div class="ibox float-e-margins">
                            <div class="ibox-title">
                                <h5>Bankverbindung</h5>
                            </div>
                            <div class="ibox-content">
                                @if(Auth::user()->hasRole('seller'))
                                    <div class="form-group{{ $errors->has('payment') ? ' has-error' : '' }}">
                                        <label for="payment" class="col-sm-2 control-label">Zahlart*</label>
                                        <div class="col-sm-10">
                                            @if($payment === null)
                                                <select id="payment" class="form-control" name="payment" required>
                                                    <option>Bitte wählen sie eine Zahlart</option>
                                                    <option value="month">Monatlich</option>
                                                    <option value="year">Jährlich</option>
                                                </select>
                                            @else
                                                <input id="payment" type="text" class="form-control" name="payment"
                                                       value="{{ trans('translations.' . Auth::user()->account->payment) }}"
                                                       disabled>
                                            @endif
                                        </div>
                                    </div>
                                @endif

                                <input type="hidden" name="id" value="{{ Auth::user()->account->id }}">

                                <div class="form-group{{ $errors->has('iban') ? ' has-error' : '' }}">
                                    <label for="iban" class="col-sm-2 control-label">IBAN*</label>

                                    <div class="col-sm-10">
                                        <input id="iban" type="text" class="form-control" name="iban"
                                               value="{{ old('iban',Auth::user()->account->iban) }}">
                                    </div>
                                </div>

                                <div class="form-group{{ $errors->has('iban_owner') ? ' has-error' : '' }}">
                                    <label for="iban_owner" class="col-sm-2 control-label">Kontoinhaber*</label>

                                    <div class="col-sm-10">
                                        <input id="iban_owner" type="text" class="form-control" name="iban_owner"
                                               value="{{ old('iban_owner',Auth::user()->account->iban_owner) }}">
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            @endcan
        @endif

        @if( Auth::user()->hasRole('agent'))
            <div class="row">
                <div class="col-md-12">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title mobile">
                            <h5>Handynummer</h5>
                        </div>
                        <div class="ibox-content">
                            @if(Auth::user()->mobile != '')
                                @if(!Auth::user()->mobile_verified)
                                    <div class="col-sm-10 col-sm-offset-2 alert alert-warning">
                                        <h3>Ihre Handynummer {{ Auth::user()->mobile }} ist noch nicht verifiziert.</h3>

                                        <a href="/user/mobile/verify" class="btn btn-warning">
                                            Aktivieren
                                        </a>
                                    </div>
                                @else
                                    <div class="col-sm-10 col-sm-offset-2 alert alert-success">
                                        Ihre Handynummer wurde bereits erfolgreich verifiziert.
                                    </div>
                                @endif
                            @endif

                            @if(Auth::user()->mobile_verification_token != '')
                                <div class="form-group{{ $errors->has('tan') ? ' has-error' : '' }}">
                                    <label for="tan" class="col-sm-2 control-label">Verifizierungs Code</label>

                                    <div class="col-sm-10">
                                        <input id="tan" type="text" class="form-control" name="tan"
                                               value="" maxlength="5">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-sm-10 col-sm-offset-2">
                                        <button type="submit" class="btn btn-primary">
                                            Absenden
                                        </button>
                                    </div>
                                </div>
                            @endif

                            <div class="form-group{{ $errors->has('mobile') ? ' has-error' : '' }}">
                                <label for="mobile" class="col-sm-2 control-label">Handynummer</label>

                                <div class="col-sm-10">
                                    <input id="mobile" type="text" class="form-control" name="mobile"
                                           value="{{old('mobile', Auth::user()->mobile) }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            <div class="col-md-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Passwort</h5>
                    </div>
                    <div class="ibox-content">
                        <div class="form-group{{ $errors->has('password_old') ? ' has-error' : '' }}">
                            <label for="password_old" class="col-sm-2 control-label">Altes Passwort</label>

                            <div class="col-sm-10">
                                <input id="password_old" type="password" class="form-control" name="password_old">
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                            <label for="password" class="col-sm-2 control-label">Neues Passwort</label>

                            <div class="col-sm-10">
                                <input id="password" type="password" class="form-control" name="password">
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                            <label for="password" class="col-sm-2 control-label">Neues Passwort bestätigen</label>

                            <div class="col-sm-10">
                                <input id="password_confirmation" type="password" class="form-control"
                                       name="password_confirmation">
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="ibox has-top-padding">
            <div class="ibox-content">
                <div class="row">
                    <div class="col-xs-12">
                        <button type="submit" class="btn btn-primary full-width">
                            Speichern
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    {!! JsValidator::formRequest('App\Http\Requests\UserRequest','#userEditForm') !!}

@endsection

@section('after-scripts')
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                if (/imgInp/.test(input.id)) {
                    reader.onload = function (e) {
                        $('#imgOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                        $('#imgOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                    }
                }

                if (/logoInp/.test(input.id)) {
                    reader.onload = function (e) {
                        $('#logoOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                        $('#logoOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                    }
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#imgInp").change(function () {
            readURL(this);
        });

        $("#logoInp").change(function () {
            readURL(this);
        });
    </script>
@endsection
