@extends('layouts.home')

@section('title', 'Benutzer bearbeiten')

@section('content')
    <div class="row">
        <form class="form-horizontal" id="userEditForm" role="form" method="POST"
              action="{{ $user->id !== null ? route('user-edit-id-post', ['user' => $user]) : route('fieldservice-creates-seller') }}">
            <div class="col-md-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Unternehmen</h5>
                        <div class="ibox-tools dropdown" dropdown="">
                            <a href="/user"><i class="fa fa-times"></i></a>
                        </div>
                    </div>
                    <div class="ibox-content">
                        {{ csrf_field() }}

                        <input type="hidden" name="id" value="{{ $user->id }}">
                        <input type="hidden" name="id" value="{{ $account->id }}">

                        <div class="form-group{{ $errors->has('salutation') ? ' has-error' : '' }}">
                            <label for="salutation" class="col-sm-2 control-label">Anrede</label>

                            <div class="col-sm-10">
                                {!! Form::select('salutation', array('Herr' => 'Herr', 'Frau' => 'Frau'), old('salutation', $user->salutation), array('class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                            <label for="firstname" class="col-sm-2 control-label">Vorname*</label>

                            <div class="col-sm-10">
                                <input id="firstname" type="text" class="form-control" name="firstname"
                                       value="{{ old('firstname', $user->firstname) }}">

                                @if ($errors->has('firstname'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('firstname') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
                            <label for="surname" class="col-sm-2 control-label">Nachname*</label>

                            <div class="col-sm-10">
                                <input id="surname" type="text" class="form-control" name="surname"
                                       value="{{ old('surname', $user->surname) }}">

                                @if ($errors->has('surname'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('surname') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('company') ? ' has-error' : '' }}">
                            <label for="company" class="col-sm-2 control-label">Firma*</label>

                            <div class="col-sm-10">
                                <input id="company" type="text" class="form-control" name="company"
                                       value="{{ old('company', $account->company) }}">

                                @if ($errors->has('company'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('company') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('zip') ? ' has-error' : '' }}">
                            <label for="zip" class="col-sm-2 control-label">PLZ*</label>

                            <div class="col-sm-10">
                                <input id="zip" type="text" class="form-control" name="zip"
                                       value="{{ old('zip', $account->zip) }}">

                                @if ($errors->has('zip'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('zip') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('city') ? ' has-error' : '' }}">
                            <label for="city" class="col-sm-2 control-label">Ort*</label>

                            <div class="col-sm-10">
                                <input id="city" type="text" class="form-control" name="city"
                                       value="{{ old('city', $account->city) }}">

                                @if ($errors->has('city'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('city') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('street') ? ' has-error' : '' }}">
                            <label for="street" class="col-sm-2 control-label">Straße*</label>

                            <div class="col-sm-10">
                                <input id="street" type="text" class="form-control" name="street"
                                       value="{{ old('street', $account->street) }}">

                                @if ($errors->has('street'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('street') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('housenumber') ? ' has-error' : '' }}">
                            <label for="housenumber" class="col-sm-2 control-label">Hausnummer*</label>

                            <div class="col-sm-10">
                                <input id="housenumber" type="text" class="form-control" name="housenumber"
                                       value="{{ old('housenumber', $account->housenumber) }}">

                                @if ($errors->has('housenumber'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('housenumber') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>


                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                            <label for="email" class="col-sm-2 control-label">E-Mail Adresse*</label>

                            <div class="col-sm-10">
                                <input id="email" type="email" class="form-control" name="email"
                                       value="{{ old('email', $user->email) }}">

                                @if ($errors->has('email'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('phone') ? ' has-error' : '' }}">
                            <label for="phone" class="col-sm-2 control-label">Telefonnummer*</label>

                            <div class="col-sm-10">
                                <input id="phone" type="text" class="form-control" name="phone"
                                       value="{{ old('phone', $user->phone) }}">

                                @if ($errors->has('phone'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('phone') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('mobile') ? ' has-error' : '' }}">
                            <label for="mobile" class="col-sm-2 control-label">Handynummer</label>

                            <div class="col-sm-10">
                                <input id="mobile" type="text" class="form-control" name="mobile"
                                       value="{{ old('mobile', $user->mobile) }}">

                                @if ($errors->has('mobile'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('mobile') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('fax') ? ' has-error' : '' }}">
                            <label for="fax" class="col-sm-2 control-label">Fax</label>

                            <div class="col-sm-10">
                                <input id="fax" type="text" class="form-control" name="fax"
                                       value="{{ old('fax', $user->fax) }}">

                                @if ($errors->has('fax'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('fax') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('all_connections') ? ' has-error' : '' }}">
                            <label for="password_old" class="col-sm-2 control-label">Empfehler*</label>

                            <div class="col-sm-10">
                                Wer darf Ihre eingestellten RECO.BON empfehlen?
                                <select name="all_connections" size="1" id="all_connections" class="form-control">
                                    <option value="1"{{ (Auth::user()->account->all_connections == '1' ? " selected":"") }}>
                                        Alle Empfehler
                                    </option>
                                    <option value="0"{{ (Auth::user()->account->all_connections == '0' ? " selected":"") }}>
                                        Nur von mir eingeladene Empfehler
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('payment') ? ' has-error' : '' }}">
                            <label for="payment" class="col-sm-2 control-label">Zahlart*</label>

                            <div class="col-sm-10">
                                {!! Form::select('payment', ['year' => 'Jährlich', 'month' => 'Monatlich'], old('payment', $account->payment), array('class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('iban') ? ' has-error' : '' }}">
                            <label for="iban" class="col-sm-2 control-label">IBAN*</label>

                            <div class="col-sm-10">
                                <input id="iban" type="text" class="form-control" name="iban"
                                       value="{{ old('iban', $account->iban) }}">

                                @if ($errors->has('iban'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('iban') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('iban_owner') ? ' has-error' : '' }}">
                            <label for="iban_owner" class="col-sm-2 control-label">Kontoinhaber*</label>

                            <div class="col-sm-10">
                                <input id="iban_owner" type="text" class="form-control" name="iban_owner"
                                       value="{{ old('iban_owner', $account->iban_owner) }}">

                                @if ($errors->has('iban_owner'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('iban_owner') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('tax_id') ? ' has-error' : '' }}">
                            <label for="tax_id" class="col-sm-2 control-label">USt-Identifikationsnummer*</label>

                            <div class="col-sm-10">
                                <input id="tax_id" type="text" class="form-control" name="tax_id"
                                       value="{{ old('tax_id', $account->tax_id) }}">

                                @if ($errors->has('tax_id'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('tax_id') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('trial') ? ' has-error' : '' }}">
                            <label for="trial" class="col-sm-2 control-label">Freimonate</label>

                            <div class="col-sm-10">
                                {!! Form::select(
                                    'trial',
                                    [
                                        '0' => 'Freimonate wählen',
                                        '1' => '1 Monat',
                                        '2' => '2 Monate',
                                        '3' => '3 Monate',
                                        '4' => '4 Monate',
                                        '5' => '5 Monate',
                                        '6' => '6 Monate',
                                        '7' => '7 Monate',
                                        '8' => '8 Monate',
                                        '9' => '9 Monate',
                                        '10' => '10 Monate',
                                        '11' => '11 Monate',
                                        '12' => '12 Monate',
                                        'free' => 'Kostenfrei',
                                    ],
                                    array('class' => 'form-control'))
                                !!}
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-10 col-sm-offset-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-btn fa-user"></i> Speichern
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @if(isset($requestClass))
                {!! JsValidator::formRequest($requestClass) !!}
            @endif
        </form>
    </div>
@endsection
