<div class="ibox float-e-margins">
    <div class="ibox-title">
        <h5>Allgemeine Daten</h5>
    </div>
    <div class="ibox-content">
        @if(Auth::user()->hasRole('seller') && Auth::user()->can('edit account data'))
            <div class="form-group{{ $errors->has('company') ? ' has-error' : '' }}">
                <label for="company" class="col-sm-2 control-label">Firma*</label>

                <div class="col-sm-10">
                    <input id="company" type="text" class="form-control" name="company"
                           value="{{ old('company', Auth::user()->account->company) }}">
                </div>
            </div>

            <div class="form-group{{ $errors->has('tax_id') ? ' has-error' : '' }}">
                <label for="tax_id" class="col-sm-2 control-label">Umsatzsteuer ID</label>

                <div class="col-sm-10">
                    <input id="tax_id" type="text" class="form-control" name="tax_id"
                           value="{{ Auth::user()->account->tax_id }}">
                </div>
            </div>

            <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                <label for="description" class="col-sm-2 control-label">Beschreibung</label>

                <div class="col-sm-10">
                                <textarea id="description" type="text" class="form-control" name="description"
                                          style="resize: vertical">{!! old('description', Auth::user()->account->description) !!}
                                </textarea>
                </div>
            </div>


            <div class="form-group{{ $errors->has('all_connections') ? ' has-error' : '' }}">
                <label for="all_connections" class="col-sm-2 control-label">Wer darf Ihre RECO.BON
                    empfehlen?*</label>

                <div class="col-sm-10">
                    <select name="all_connections" size="1" id="all_connections" class="form-control">
                        <option value="1"{{ (Auth::user()->account->all_connections == '1' ? " selected":"") }}>
                            Alle Empfehler
                        </option>
                        <option value="0"{{ (Auth::user()->account->all_connections == '0' ? " selected":"") }}>
                            Nur von mir eingeladene Empfehler
                        </option>
                    </select>
                </div>
            </div>
        @endif

        @can('edit account')
        <div class="form-group{{ $errors->has('street') ? ' has-error' : '' }}">
            <label for="street" class="col-sm-2 control-label">Straße*</label>

            <div class="col-sm-10">
                <input id="street" type="text" class="form-control" name="street"
                       value="{{ old('street', Auth::user()->account->street) }}">
            </div>
        </div>


        <div class="form-group{{ $errors->has('housenumber') ? ' has-error' : '' }}">
            <label for="housenumber" class="col-sm-2 control-label">Hausnummer*</label>

            <div class="col-sm-10">
                <input id="housenumber" type="text" class="form-control" name="housenumber"
                       value="{{ old('housenumber', Auth::user()->account->housenumber) }}">
            </div>
        </div>

        <div class="form-group{{ $errors->has('zip') ? ' has-error' : '' }}">
            <label for="zip" class="col-sm-2 control-label">PLZ*</label>

            <div class="col-sm-10">
                <input id="zip" type="text" class="form-control" name="zip"
                       value="{{ old('zip', Auth::user()->account->zip) }}">
            </div>
        </div>

        <div class="form-group{{ $errors->has('city') ? ' has-error' : '' }}">
            <label for="city" class="col-sm-2 control-label">Ort*</label>

            <div class="col-sm-10">
                <input id="city" type="text" class="form-control" name="city"
                       value="{{ old('city', Auth::user()->account->city) }}">
            </div>
        </div>
        @endcan


        @if( Auth::user()->hasRole('seller'))
            <div class="form-group">
                <label for="email" class="col-md-2 control-label">Firmenlogo</label>

                <div class="col-xs-12 col-md-10 text-center">
                    <img data-lightbox="image-1" class="account-image" id="logoOutput"
                         src="@if(Auth::user()->account->upload_portrait != ''){{ route('account-portrait', Auth::user()->account->upload_portrait) }}@else{{ '/img/logo_company.png' }}@endif">
                </div>

                <div class="upload col-md-10 col-sm-offset-2">
                    <p>
                        Wählen Sie eine Bilddatei mit Ihrem Firmenlogo (*.jpeg, *.jpg, *.png *.gif) von Ihrem Rechner aus:<br>
                        *Maximum 200x200 Pixel
                        <input name="upload_portrait" type="file" size="50" accept="image/*"
                               class="btn btn-primary" id="logoInp">
                    </p>
                </div>
            </div>

            <div class="form-group">
                <label for="picture" class="col-md-2 control-label">Bild</label>

                <div class="col-xs-12 col-md-10 text-center">
                    <img src="{{ asset(Auth::user()->account->picture) }}"
                         id="sellerPicture"
                         @if(!Auth::user()->account->picture) style="display: none" @endif
                    >
                </div>

                <div class="upload col-md-10 col-sm-offset-2">
                    <p>
                        <input name="picture" type="file" size="50" accept="image/*" class="btn btn-primary" id="sellerPictureInput">
                    </p>
                </div>
            </div>

            <div class="form-group">
                <label class="col-md-2 control-label">Arbeitszeit</label>
                <div class="col-md-10">
                    <input type="text" id="wt1" name="wt1" value="{{ old('wt1', json_decode(Auth::user()->account->worktimes)[0]) }}" placeholder="Montag" />
                    <input type="text" id="wt2" name="wt2" value="{{ old('wt2', json_decode(Auth::user()->account->worktimes)[1]) }}" placeholder="Dienstag" />
                    <input type="text" id="wt3" name="wt3" value="{{ old('wt3', json_decode(Auth::user()->account->worktimes)[2]) }}" placeholder="Mittwoch" />
                    <input type="text" id="wt4" name="wt4" value="{{ old('wt4', json_decode(Auth::user()->account->worktimes)[3]) }}" placeholder="Donnerstag" />
                    <input type="text" id="wt5" name="wt5" value="{{ old('wt5', json_decode(Auth::user()->account->worktimes)[4]) }}" placeholder="Freitag" />
                    <input type="text" id="wt6" name="wt6" value="{{ old('wt6', json_decode(Auth::user()->account->worktimes)[5]) }}" placeholder="Samstag" />
                    <input type="text" id="wt7" name="wt7" value="{{ old('wt7', json_decode(Auth::user()->account->worktimes)[6]) }}" placeholder="Sonntag" />
                </div>
            </div>
        @endif

    </div>
</div>