@extends('layouts.home')

@section('title', 'Transaktionen')

@section('content')
    <div class="row">
        @foreach($numbers as $number)
            <div class="col-lg-3">
                @include('dashboard.partials.number', $number)
            </div>
        @endforeach
    </div>

    @include('partials.transaction-status')

    @can('export sepa files')
    <div class="row">
        <div class="col-md-4 col-sm-12">
            <div class="ibox dashboard-button float-e-margins">
                <a class="ibox-content invite" type="button" href="{{ route('transaction-sepa-debit') }}"><i
                            class="fa fa-download"></i>&nbsp;SEPA Lastschriften exportieren</a>
            </div>
        </div>
        <div class="col-md-4 col-sm-12">
            <div class="ibox dashboard-button float-e-margins">
                <a class="ibox-content invite" type="button" href="{{ route('transaction-sepa-credit') }}"><i
                            class="fa fa-download"></i>&nbsp;SEPA Überweisungen exportieren</a>
            </div>
        </div>
        <div class="col-md-4 col-sm-12">
            <div class="ibox dashboard-button float-e-margins">
                <a class="ibox-content invite" type="button" target="_blank" href="{{ route('transfer') }}"><i
                            class="fa fa-download"></i>&nbsp;SEPA Umbuchung exportieren</a>
            </div>
        </div>
    </div>
    @endcan

    @include('partials/global-filters')

    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    @if(Auth::user()->hasRole('operator'))
                        <h5>Transaktionen</h5>
                    @else
                        <h5>Konto </h5>
                    @endif
                </div>
                <div class="ibox-content">
                    {!! $grid->__toString() !!}
                </div>
            </div>
        </div>
    </div>

    {{--Bewertungs Modal--}}
    <div class="modal fade" id="rateModal"
         tabindex="-1" role="dialog"
         aria-labelledby="rateModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close"
                            data-dismiss="modal"
                            aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"
                        id="rateModalLabel">Bewertung</h4>
                </div>

                <form class="form-horizontal" role="form" method="POST"
                      action="{{ url('/transaction/rate') }}">
                    {{ csrf_field() }}

                    <div class="modal-body">
                        <input type="hidden" name="transaction_id" id="transaction_id" value="">

                        <div class="form-group">
                            <input id="input-1" name="rating" class="rating rating-loading" data-min="0" data-max="5"
                                   data-step="1">
                        </div>

                        <div class="form-group">
                            <textarea name="description" id="description"
                                      placeholder="Schreiben Sie eine Bewertung"></textarea>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button"
                                class="btn btn-default"
                                data-dismiss="modal">Schließen
                        </button>
                        <span class="pull-right">
                  <button type="submit" class="btn btn-primary">
                      Senden
                  </button>
                </span>
                    </div>


                </form>

            </div>
        </div>
    </div>


    {{--Modals--}}
    <div id="confirmPayoutModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;  </button>
                    <h4 class="modal-title" id="myModalLabel">Auszahlung bestätigen</h4>
                </div>
                <div class="modal-body">
                    <p>
                    @if($requestCount)
                        <div class="alert alert-success">
                            Es sind {{ $requestCount }} Gutschrifte(n) mit einem Gesamt Betrag
                            von {{ Format::currency($requestAmount) }} auszahlbar.
                            @if(!$incompleteProfile)
                            Bitte bestätigen Sie die Auszahlung.
                            @endif
                        </div>
                        @if($incompleteProfile)
                            <div class="alert alert-warning">
                                Wir benötigen noch Deine Adressdaten und Bankverbindung um die Auszahlung einleiten zu können.
                            </div>
                        @endif
                    @endif
                    @if($pendingCount)
                        <div class="alert alert-warning">
                            Es sind {{ $pendingCount }} Gutschrifte(n) offen.
                            @can('show consumer transactions')
                                Bitte befolgen Sie die Anweisungen in der Spalte "nächster Schritt" um diese zur Auszahlung zu bringen.'
                            @else
                                {{--FIXME: Bei Multi Rollen würden wir hier wohl nächster Schritt für alle Rollen einfügen - damit fällt das Else weg--}}
                                Bitte warten Sie ab, bis die Transaktionen bereit zur Auszahlung sind.
                            @endcan
                        </div>
                    @endif
                    @if($pendingCount == 0 && $requestCount == 0)
                        Es sind aktuell keine Gutschriften offen oder auszahlbar.
                    @endif


                </div>
                <div class="modal-footer">
                    @if($requestCount)
                        @if($incompleteProfile)
                            <a type="button" class="btn btn-primary" href="{{ route('user-profile') }}">Profil vervollständigen</a>
                        @else
                            <a type="button" class="btn btn-primary" href="{{ route('transaction-request-all-payments') }}">Auszahlen</a>
                        @endif
                    @endif
                    <button type="button" class="btn btn-default" data-dismiss="modal">Schließen</button>
                </div>
            </div>
        </div>
    </div>

    {{--Export Modal--}}
    <div class="modal fade" id="exportModal"
         tabindex="-1" role="dialog"
         aria-labelledby="exportModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close"
                            data-dismiss="modal"
                            aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"
                        id="exportModalLabel">Exportieren</h4>
                </div>

                <form id="exportModalForm" class="form-horizontal" role="form" method="GET">
                    {{ csrf_field() }}

                    <div class="modal-body">
                        <p>Wirklich exportieren?</p>
                    </div>

                    <div class="modal-footer">
                        <button type="button"
                                class="btn btn-default"
                                data-dismiss="modal">Schließen
                        </button>
                        <span class="pull-right">
                  <button type="submit" class="btn btn-primary">
                      Senden
                  </button>
                </span>
                    </div>


                </form>

            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $(function () {

            $('#rateModal').on('show.bs.modal', function (e) {
                var transactionid = $(e.relatedTarget).data('transactionid');
                $(e.currentTarget).find('#transaction_id').val(transactionid);
            });


            $('.button-payout').click(function (e) {
                e.preventDefault();
                var $modal = $('#confirmPayoutModal');
                $modal.modal('show');
            });

            $('.button-export').click(function (e) {
                e.preventDefault();
                var $url = $(this).attr("href");
                var $modal = $('#exportModal');
                $('#exportModalForm').attr('action', $url);
                $modal.modal('show');
            });

            if (window.location.hash == '#confirmPayoutModal') {
                $('.button-payout').click();
            }
        });

    </script>
    <script>
        // with plugin options
        $("#input-1").rating({language: 'de'});
    </script>
@endsection


