@extends('layouts.home')

@section('title', 'RECO.BON Versenden')

@section('content')


    <div class="rows share-coupons">
        <div class="col-lg-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>RECO.BONS Versenden</h5>
                </div>
                <div class="ibox-content">

                    <form class="form-horizontal" role="form" method="POST" action="{{ url($action) }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="tokenId" value="{{$tokenId}}">
                        <input type="hidden" name="recommend_id" value="{{ $recommend->id }}">
                        <input type="hidden" name="customized" id="customized" value="{{ old('customized') }}">

                        <div class="form-group{{ $errors->has('salutation') ? ' has-error' : '' }}">
                            <label for="salutation" class="col-sm-3 control-label">Anrede*</label>

                            <div class="col-sm-9">
                                {!! Form::select('salutation', array('Herr' => 'Herr', 'Frau' => 'Frau'), old('salutation'), array('class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                            <label class="col-sm-3 control-label" for="firstname">Vorname*</label>

                            <div class="col-sm-9">
                                <input id="firstname" type="text" class="form-control" name="firstname"
                                       value="{{ old('firstname') }}"
                                       placeholder="">

                                @if ($errors->has('firstname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('firstname') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
                            <label class="col-sm-3 control-label" for="surname">Nachname*</label>

                            <div class="col-sm-9">
                                <input id="surname" type="text" class="form-control" name="surname"
                                       value="{{ old('surname') }}"
                                       placeholder="">

                                @if ($errors->has('surname'))
                                    <span class="help-block">
                                            <strong>{{ $errors->first('surname') }}</strong>
                                        </span>
                                @endif
                            </div>
                        </div>
                        @if($type === 'sms')
                            @if(!Auth::user()->mobile_verified && !Auth::user()->hasRole('seller'))
                                <div class="col-sm-9 col-sm-offset-3 alert alert-warning">
                                    <h3>Ihre Handynummer {{ Auth::user()->mobile }} ist noch nicht verifiziert.</h3>

                                    <a href="/user/profile#mobile" class="btn btn-warning">
                                        Zur Verifizierung
                                    </a>
                                </div>
                            @endif
                            <div class="form-group{{ $errors->has('mobile') ? ' has-error' : '' }}">
                                <label class="col-sm-3 control-label" for="mobile">Handynummer*</label>

                                <div class="col-sm-9">
                                    <input id="mobile" type="text" class="form-control fill-in" name="mobile"
                                           value="{{ old('mobile') }}"
                                           placeholder="">

                                    @if ($errors->has('mobile'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('mobile') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>


                            <div class="form-group{{ $errors->has('smsText') ? ' has-error' : '' }}">
                                <label class="col-sm-3 control-label" for="smsText">SMS-Nachricht</label>

                                <div class="col-sm-9">
                                    @if ($errors->has('smsText'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('smsText') }}</strong>
                                        </span>
                                    @endif
                                    <div class="preview">
                                        <textarea id="messagetext" rows="10" class="form-control"
                                              name="smsText">{{ old('smsText') }}</textarea>
                                    </div>

                                </div>
                            </div>
                        @else

                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                <label class="col-sm-3 control-label" for="email">E-Mail*</label>

                                <div class="col-sm-9">
                                    <input id="email" type="email" class="form-control fill-in" name="email"
                                           value="{{ old('email') }}"
                                           placeholder="">

                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="clear"></div>

                            <div class="form-group{{ $errors->has('emailText') ? ' has-error' : '' }}">
                                <label class="col-sm-3 control-label" for="emailText">E-Mail-Nachricht</label>

                                <div class="col-sm-9">
                                    @if ($errors->has('emailText'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('emailText') }}</strong>
                                        </span>
                                    @endif
                                    <div class="preview">
                                    <textarea id="messagetext" rows="10" class="form-control"
                                              name="emailText">{{ old('emailText') }}</textarea>
                                    </div>

                                </div>
                            </div>
                        @endif

                        <div class="form-group">
                            <div class="col-sm-9 col-sm-offset-3">
                                <button class="btn btn-primary" type="submit"> Senden</button>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Vorschau</h5>
                </div>
                <div class="ibox-content">
                    @if($recommend instanceof \App\Account)
                        @include('partials/coupon', [
                            'seller' => $recommend,
                            'agent' => Auth::user(),
                            ])
                    @else
                        @include('partials/coupon', [
                            'template' => $recommend,
                            'agent' => Auth::user(),
                            ])
                    @endif
                </div>
            </div>
        </div>
    </div>

@endsection

@section('after-scripts')
    <script type="text/javascript">
        $(document).ready(function () {
            var agentDisplayName = {!! json_encode(Auth::user()->getDisplayName()) !!};
            var selectEmail = $('#email');
            var selectMobile = $('#mobile');
            var firstname = 'Vorname';
            var surname = 'Nachname';
            var selectorFirstname = $('#firstname');
            var selectorSurname = $('#surname');
            var messageText = $('#messagetext');
            var standardMessageText;

            selectorFirstname.change(function () {
                createEmailtext();
            });

            selectorSurname.change(function () {
                createEmailtext();
            });


            function personalizeText(template, firstname, surname) {
                template = template.replace('%firstname%', firstname);
                template = template.replace('%surname%', surname);
                return template;
            }

            function createEmailtext() {
                if ($('#customized').val() == 1) {
                    return;
                }
                if (selectorFirstname.val() != '') {
                    firstname = selectorFirstname.val();
                } else {
                    firstname = '';
                }
                if (selectorSurname.val() != '') {
                    surname = selectorSurname.val();
                } else {
                    surname = '';
                }

                messageText.val(personalizeText({!! json_encode($personalTextTemplate) !!}, firstname, surname));
            }

            selectEmail.change(function () {
                if ($(this).val()) {
                    var text = $(this).val();
                } else {
                    var text = 'den Kunden';
                }
                $('.mail-receiver').text(text);
            });

            selectMobile.change(function () {
                if ($(this).val()) {
                    var text = $(this).val();
                } else {
                    var text = 'den Kunden';
                }
                $('.sms-receiver').text(text);
            }).change();

            messageText.change(function () {
                $('#customized').val(1);
            });

            createEmailtext();

        });
    </script>
@endsection

