@extends('layouts.home')

@section('title', 'Benutzerverwaltung')

@section('content')
    <div class="row">
        <div class="col-md-12">
            @include('partials/global-filters')

            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Meine Unternehmen</h5>
                </div>
                <div class="ibox-content">
                    {!! $myseller->__toString() !!}
                </div>
            </div>

            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <a name="allPartners"></a>
                        <h5>Alle Unternehmen</h5>
                </div>
                <div class="ibox-content">
                    {!! $grid->__toString() !!}
                </div>
            </div>
        </div>
    </div>

    {{--Modal FIXME: ab in nen partial --}}
    <div id="deleteModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;  </button>
                    <h4 class="modal-title" id="myModalLabel">Löschen</h4>
                </div>
                <div class="modal-body">
                    <p>
                        Das Unternehmen <strong class="seller"></strong> wirklich Löschen?
                    </p>
                </div>
                <div class="modal-footer">
                    <a type="button" class="btn btn-primary">Löschen</a>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Schließen</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $('.delete-via-modal').click(function () {
            $('#deleteModal').modal('show');
            $('#deleteModal .btn-primary').attr('href', $(this).attr('data-delete-href'));
            $('#deleteModal .seller').html($(this).parent().parent().find('.column-company').html());
        });
    </script>
@endsection