<!DOCTYPE html>
<html lang="{{App::getLocale()}}">
<head>
    <title>@yield('title') - RECO.MA</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <script src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.16/webfont.js"></script>
    <script>
        WebFont.load({
            google: {
                "families": ["Poppins:300,400,500,600,700", "Roboto:300,400,500,600,700"]
            },
            active: function() {
                sessionStorage.fonts = true;
            }
        });
    </script>

    <link href="{{ asset('metronic/vendors/general/perfect-scrollbar/css/perfect-scrollbar.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/vendors/general/@fortawesome/fontawesome-free/css/all.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/vendors/custom/vendors/line-awesome/css/line-awesome.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/vendors/general/sweetalert2/dist/sweetalert2.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/vendors/general/toastr/build/toastr.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/vendors/general/slick/slick.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/vendors/general/slick/slick-theme.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ asset('metronic/css/styles/style.bundle.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/css/styles/skins/header/base/light.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/css/styles/skins/header/menu/light.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/css/styles/skins/brand/dark.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('metronic/css/styles/skins/aside/dark.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ asset('metronic/css/styles/custom.css') }}" rel="stylesheet" type="text/css" />
    
    @yield('styles-page')
</head>

<body class="t-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-aside--enabled kt-aside--fixed kt-page--loading @yield('body-class')">
    @include('redesign.back.metronic.pieces.header_mobile')

    <div class="kt-grid kt-grid--hor kt-grid--root">
        <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
            @include('redesign.back.metronic.pieces.aside')

            <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
                @include('redesign.back.metronic.pieces.header')

                <div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
                    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
                        @yield('document')
                    </div>
                </div>

                @include('redesign.back.metronic.pieces.footer')
            </div>
        </div>
    </div>

    <div id="overlay" style="@yield('overlay-style')">
        <div class="kt-spinner kt-spinner--md kt-spinner--info"></div>
    </div>

    @if(session('notification'))
        <div id="swalMsg" data-type="{{ session('notification')->type }}" data-msg="{{ session('notification')->message }}"></div>
    @endif

    <script>
        var KTAppOptions = {
            "colors": {
                "state": {
                    "brand": "#5d78ff",
                    "dark": "#282a3c",
                    "light": "#ffffff",
                    "primary": "#5867dd",
                    "success": "#34bfa3",
                    "info": "#36a3f7",
                    "warning": "#ffb822",
                    "danger": "#fd3995"
                },
                "base": {
                    "label": ["#c5cbe3", "#a1a8c3", "#3d4465", "#3e4466"],
                    "shape": ["#f0f3ff", "#d9dffa", "#afb4d4", "#646c9a"]
                }
            }
        };
    </script>

    @include('redesign.back.metronic.pieces.onboarding')

    @include('redesign.pieces.cmp')

    <script src="{{ asset('metronic/vendors/general/jquery/dist/jquery.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/popper.js/dist/umd/popper.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/bootstrap/dist/js/bootstrap.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/js-cookie/src/js.cookie.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/moment/min/moment.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/tooltip.js/dist/umd/tooltip.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/perfect-scrollbar/dist/perfect-scrollbar.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/sticky-js/dist/sticky.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/wnumb/wNumb.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/block-ui/jquery.blockUI.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/es6-promise-polyfill/promise.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/sweetalert2/dist/sweetalert2.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/custom/js/vendors/sweetalert2.init.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/toastr/build/toastr.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/vendors/general/slick/slick.min.js') }}" type="text/javascript"></script>

    <script src="{{ asset('js/plugins/mark/jquery.mark.min.js') }}"></script>
    <script src="{{ asset('js/plugins/clipboard/clipboard.min.js') }}"></script>

    <script src="{{ asset('metronic/js/scripts/scripts.bundle.js') }}" type="text/javascript"></script>
    <script src="{{ asset('metronic/js/scripts/back.js') }}" type="text/javascript"></script>

    @yield('scripts-page')
</body>

</html>