<!DOCTYPE html>
<html lang="{{App::getLocale()}}" style="@yield('html-style')">
    <head>
        <title>@yield('title') - RECO.MA</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}" />

        <link href="{{ asset('metronic/vendors/general/@fortawesome/fontawesome-free/css/all.min.css') }}" rel="stylesheet" type="text/css" />
        <link rel="stylesheet" href="{{ asset('listeo/css/style.css') }}">
        <link rel="stylesheet" href="{{ asset('listeo/css/colors/recoma.css') }}">
        <link rel="stylesheet" href="{{ asset('listeo/css/custom.css') }}">

        @yield('styles-page')

        @include('redesign.front.pieces.meta.common')
    </head>
    <body class="@yield('body-class')">
        <div id="wrapper">
            @include('redesign.front.listeo.pieces.header')
            @yield('document')
            @include('redesign.front.listeo.pieces.footer')
        </div>

        @yield('bar')

        @include('redesign.front.listeo.pieces.overlay')

        @if (Auth::user())
            @include('redesign.front.listeo.pieces.onboarding')
        @endif

        @if(session('notification'))
            <div id="swalMsg" data-type="{{ session('notification')->type }}" data-msg="{{ session('notification')->message }}"></div>
        @endif

        <script type="text/javascript" src="{{ asset('listeo/scripts/jquery-2.2.0.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/mmenu.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/chosen.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/slick.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/rangeslider.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/magnific-popup.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/waypoints.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/counterup.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/jquery-ui.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/tooltips.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('js/plugins/swal/swal2.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('js/plugins/clipboard/clipboard.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/custom.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/front.js') }}"></script>
        <script type="text/javascript" src="{{ asset('js/plugins/zxcvbn/zxcvbn.js') }}"></script>
        <script type="text/javascript" src="{{ asset('listeo/scripts/auth.js') }}"></script>

        @if (Auth::user())
            <script>
                window.fbAsyncInit = function() {
                    FB.init({
                        appId            : {{ config('services.facebook.app_id') }},
                        autoLogAppEvents : true,
                        xfbml            : true,
                        version          : 'v3.2'
                    });
                };

                (function(d, s, id){
                    var js, fjs = d.getElementsByTagName(s)[0];
                    if (d.getElementById(id)) {return;}
                    js = d.createElement(s); js.id = id;
                    js.src = "https://connect.facebook.net/en_US/sdk.js";
                    fjs.parentNode.insertBefore(js, fjs);
                }(document, 'script', 'facebook-jssdk'));
            </script>
        @endif

        @yield('scripts-page')
    </body>

    @include('redesign.pieces.cmp')
</html>