<!DOCTYPE html>
<html lang="{{App::getLocale()}}" style="height:100%">
<head>
    <title>@yield('title') - RECO.MA</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    @yield('meta')

    <link rel="stylesheet" href="{{ asset('listeo/css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('listeo/css/colors/recoma.css') }}">
    <link rel="stylesheet" href="{{ asset('listeo/css/custom.css') }}">

    @yield('styles-page')
</head>
<body style="background: #f9f9f9" class="@yield('body-classes')">
    @yield('landing')

    <div id="authFormHolder" class="sign-in-form">
        @if ( ( isset($referrer) && $referrer->hasRole('seller') ) || isset($seller) || isset($deal) )
            <div id="authFormHolderCloseBtn" onclick="document.body.classList.add('modal-open');document.getElementById('registerFormLandingHolder').style.display='block';">
                <i class="im im-icon-Close-Window"></i>
            </div>
        @endif

        <div id="authLogo" class="text-center">
            <a href="{{ route('home') }}">
                <img src="{{ asset('img/logo_200x56.png') }}" />
            </a>
        </div>
        @yield('form')
    </div>

    <div id="authFooter">
        <div class="text-center">
            <div id="authFooterMenu">
                <a href="{{ route('agb') }}" target="_blank" class="kt-footer__menu-link kt-link">AGB</a>
                <a href="{{ route('privacy') }}" target="_blank" class="kt-footer__menu-link kt-link">Datenschutz</a>
                <a href="{{ route('impressum') }}" target="_blank" class="kt-footer__menu-link kt-link">Impressum</a>
                <a href="{{ route('faq') }}" target="_blank" class="kt-footer__menu-link kt-link">FAQ</a>
            </div>
        </div>
    </div>

    <div id="authOverlay"></div>

    @if(session('notification'))
        <div id="swalMsg" data-type="{{ session('notification')->type }}" data-msg="{{ session('notification')->message }}"></div>
    @endif

    @include('redesign.pieces.cmp')

    <link rel="stylesheet" href="{{ asset('listeo/css/custom.css') }}">

    <script type="text/javascript" src="{{ asset('listeo/scripts/jquery-2.2.0.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/plugins/swal/swal2.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/plugins/zxcvbn/zxcvbn.js') }}"></script>
    <script type="text/javascript" src="{{ asset('listeo/scripts/auth.js') }}"></script>
</body>
</html>