@extends('redesign.layouts.app')

@section('html-style', 'height:100%')

@section('styles')
    <link rel="stylesheet" href="{{ asset('css/plugins/bootstrap/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/bootstrap/bootstrap-datepicker3.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/fontawesome/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/styles.css') }}">
@endsection

@section('scripts-vendor')
    <script src="{{ asset('js/plugins/jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('js/plugins/popper/popper.min.js') }}"></script>
    <script src="{{ asset('js/plugins/bootstrap/bootstrap.min.js') }}"></script>
    <script src="{{ asset('js/plugins/swal/swal2.min.js') }}"></script>
@endsection

@section('content')
    <div class="d-flex align-items-center" id="dashboardHolder">
        <div id="dashboardHeader">
            <div class="container">
                <nav class="navbar navbar-light">
                    <a href="{{ route('user.profile') }}">
                        <div class="userpic" style="margin: 0; background-image:url({{ Auth::user()->userpic }})"></div>
                        <span class="d-none d-sm-inline">{{ Auth::user()->fullname }}</span>
                    </a>
                    <div>
                        @if( 'dashboard/seller' !==  Request::path() )
                            <a href="{{ route('home') }}"><i class="fas fa-home"></i> RECO.MA &rarr;</a>
                        @endif
                        <span class="navbar-text">@yield('documentTitle')</span>
                    </div>
                </nav>
            </div>
        </div>

        @yield('document')

        <div id="dashboardFooter">
            <div class="container text-center">
                <span>powered by</span>
                <a href="{{ route('home') }}">
                    <img id="dashboardLogo" src="{{ asset('img/logo_200x56.png') }}" />
                </a>
            </div>
        </div>
    </div>

    <div id="overlay" style="@yield('overlay-style')"></div>
@endsection