@extends('redesign.layouts.app')

@section('body-class', 'front')

@section('styles')
    <link rel="stylesheet" href="{{ asset('css/plugins/bootstrap/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/bootstrap/bootstrap-select.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/fontawesome/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/slick/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/slick/slick-theme.css') }}">
    <link rel="stylesheet" href="{{ asset('css/styles.css') }}">
@endsection

@section('scripts-vendor')
    @if (Auth::user())
    <script>
        window.fbAsyncInit = function() {
            FB.init({
                appId            : {{ config('services.facebook.app_id') }},
                autoLogAppEvents : true,
                xfbml            : true,
                version          : 'v3.2'
            });
        };

        (function(d, s, id){
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) {return;}
            js = d.createElement(s); js.id = id;
            js.src = "https://connect.facebook.net/en_US/sdk.js";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    </script>
    @endif

    <script src="{{ asset('js/plugins/jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('js/plugins/jquery-ui/draggable/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('js/plugins/jquery-ui/touch/jquery.ui.touch-punch.min.js') }}"></script>
    <script src="{{ asset('js/plugins/popper/popper.min.js') }}"></script>
    <script src="{{ asset('js/plugins/bootstrap/bootstrap.min.js') }}"></script>
    <script src="{{ asset('js/plugins/bootstrap/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('js/plugins/swal/swal2.min.js') }}"></script>
    <script src="{{ asset('js/plugins/slick/slick.min.js') }}"></script>
    <script src="{{ asset('js/plugins/clipboard/clipboard.min.js') }}"></script>
@endsection

@section('content')
    @if(true === hisorange\BrowserDetect\Facade\Parser::isMobile())
        @include('redesign.front.pieces.header_mobile')
    @else
        @include('redesign.front.pieces.header')
    @endif

    @if (true === config('recoma.openedSystem'))
        @include('redesign.front.pieces.category.top')
    @endif

    @if ( Auth::user() && !Auth::user()->hasRole('seller') && (!Auth::user()->firstname && !Auth::user()->surname) )
        @include('redesign.front.pieces.forms.name')
    @endif

    @yield('document')

    @include('redesign.front.pieces.footer')
    @include('redesign.front.pieces.bar')
@endsection