@extends('redesign.layouts.app')

@section('html-style', 'height:100%')

@section('styles')
    <link rel="stylesheet" href="{{ asset('css/plugins/bootstrap/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/bootstrap/bootstrap-datepicker3.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/fontawesome/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/nouislider/nouislider.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/bootstrap/jquery.bootstrap-touchspin.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/slick/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/slick/slick-theme.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins/intro/introjs.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/styles.css') }}">
@endsection

@section('scripts-vendor')
    <script src="{{ asset('js/plugins/jquery/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('js/plugins/popper/popper.min.js') }}"></script>
    <script src="{{ asset('js/plugins/bootstrap/bootstrap.min.js') }}"></script>
    <script src="{{ asset('js/plugins/swal/swal2.min.js') }}"></script>
    <script src="{{ asset('js/plugins/clipboard/clipboard.min.js') }}"></script>
    <script src="{{ asset('js/plugins/mark/jquery.mark.min.js') }}"></script>
    <script src="{{ asset('js/plugins/intro/intro.min.js') }}"></script>
    <script src="{{ asset('js/back.js') }}"></script>
@endsection

@section('content')
    <div class="d-flex align-items-center" id="dashboardHolder">
        <div id="dashboardHeader">
            <div class="container">
                <nav class="navbar navbar-light">
                    <a href="{{ route('seller.profile.index') }}">
                        <div class="userpic" style="margin: 0; background-image:url({{ Auth::user()->userpic }})"></div>
                        <span class="d-none d-sm-inline">{{ Auth::user()->fullname }}</span>
                    </a>
                    <div>
                        @if( 'dashboard/seller' !==  Request::path() )
                            <a href="{{ route('home') }}"><i class="fas fa-tachometer-alt"></i> Dashboard &rarr;</a>
                        @endif
                        <span class="navbar-text">@yield('documentTitle')</span>
                    </div>
                </nav>
            </div>
        </div>

        @yield('document')

        <div id="dashboardFooter">
            <div class="container text-center position-relative">
                <div id="startTourBtn" class="startTourBtn" data-toggle="tooltip" data-title="Hilfe">
                    <i class="far fa-question-circle"></i>
                </div>

                <span>powered by</span>
                <a href="{{ route('home') }}">
                    <img id="dashboardLogo" src="{{ asset('img/logo_200x56.png') }}" />
                </a>

                <a href="{{ url('logout') }}" id="logoutBtn" class="logoutBtn">
                    <span>Abmelden</span> <i class="fas fa-sign-out-alt"></i>
                </a>
            </div>
        </div>
    </div>

    <div id="overlay" style="@yield('overlay-style')">
        <div class="sk-fading-circle">
            <div class="sk-circle1 sk-circle"></div>
            <div class="sk-circle2 sk-circle"></div>
            <div class="sk-circle3 sk-circle"></div>
            <div class="sk-circle4 sk-circle"></div>
            <div class="sk-circle5 sk-circle"></div>
            <div class="sk-circle6 sk-circle"></div>
            <div class="sk-circle7 sk-circle"></div>
            <div class="sk-circle8 sk-circle"></div>
            <div class="sk-circle9 sk-circle"></div>
            <div class="sk-circle10 sk-circle"></div>
            <div class="sk-circle11 sk-circle"></div>
            <div class="sk-circle12 sk-circle"></div>
        </div>
    </div>

    @if(session('notification'))
        <div id="swalMsg" data-type="{{ session('notification')->type }}" data-msg="{{ session('notification')->message }}"></div>
    @endif
@endsection