@extends('redesign.layouts.listeo.front')

@section('title', 'Mein Konto')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Mein Konto</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Mein Konto'])
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        @if ( $transactions->count() )
            @include('redesign.front.listeo.pieces.transactions_counters')

            @if(!$user->email_verified)
                <div class="notification error closeable">
                    <a class="close"></a>
                    <p>Bitte bestätige Deine E-Mail, damit Du Dein Cashback auszahlen kannst. Wir haben eine Bestätigungsmail mit einem Link an <strong>{{ $user->email_temp ? $user->email_temp : $user->email }}</strong> gesendet.</p>
                    <p>Sollte die E-Mail nicht angekommen sein bitte <a href="#" class="alert-link" id="emailVerificationSend">hier klicken</a>.</p>
                </div>
            @endif

            @if ( !$user->hasPaymentType() )
                <div class="notification error closeable">
                    <a class="close"></a>
                    Du hast keine Zahlungsdaten. <a href="{{ route('user.profile') . '#payment' }}">Jetzt einstellen</a>
                </div>
            @endif

            <div class="text-center">
                @if ( $totals->allocated <= 0 )
                    <a class="button disabled" id="payoutBtnMock">Auszahlen</a>
                @else
                    <a class="button" href="{{ route('user.payout') }}" id="payoutBtn">Auszahlen</a>
                @endif
            </div>

            @include('redesign.front.listeo.pieces.transactions', ['transactions' => $transactions])
        @else
            <h3 class="margin-bottom-100">Es liegen noch keine Aktivitäten vor.</h3>
        @endif
    </div>
@endsection