@extends('redesign.layouts.listeo.front')

@section('title', 'Unternehmen einladen')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Unternehmen einladen</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Unternehmen einladen'])
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <h3 class="headline centered headline-extra-spacing">
            <strong class="headline-with-separator">Hier ist dein persönlicher Empfehlungslink um Unternehmen zu RECO.MA einzuladen</strong>

            <span id="refLink" class="margin-top-25" value="{{ $links->raw }}">{{ $links->raw }}</span>
        </h3>

        @include('redesign.front.listeo.pieces.reflinks_invite')

        @if ( $sellers->count() )
            @include('redesign.front.listeo.pieces.invited_sellers', ['sellers' => $sellers])
        @else
            <h3 class="margin-bottom-100">Du hast noch keine Unternehmen eingeladen.</h3>
        @endif
    </div>
@endsection