@extends('redesign.layouts.listeo.front')

@section('title', 'Meine Bewertungen')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Meine Bewertungen</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Meine Bewertungen'])
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        @if ($reviews->count())
            <section class="comments listing-reviews">
                <ul>
                    @foreach($reviews as $review)
                        @include('redesign.front.listeo.pieces.review.for_user', ['review' => $review])
                    @endforeach
                </ul>
            </section>
        @else
            <h3 class="margin-bottom-100">Du hast noch keine Bewertungen abgegeben.</h3>
        @endif
    </div>
@endsection