@extends('redesign.layouts.listeo.front')

@section('title', 'Meine Empfehlungen')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Meine Empfehlungen</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Meine Empfehlungen'])
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <h3 class="headline centered headline-extra-spacing">
            @if (true === config('recoma.openedSystem'))
                <strong class="headline-with-separator">Hier ist dein persönlicher Empfehlungslink um deine Freunde zu RECO.MA einzuladen</strong>
            @else
                <strong class="headline-with-separator">Hier ist dein persönlicher Empfehlungslink um <strong>{{ $attachedSeller ? $attachedSeller->account->company : '' }}</strong> zu empfehlen</strong>
            @endif
            <span id="refLink" class="margin-top-25" value="{{ $links->raw }}">{{ $links->raw }}</span>
        </h3>

        @include('redesign.front.listeo.pieces.reflinks')

        @if ( $referrals->count() )
            @include('redesign.front.listeo.pieces.referrals', ['referrals' => $referrals])
        @else
            <h3 class="margin-bottom-100">Du hast noch keine Empfehlungen abgegeben.</h3>
        @endif
    </div>
@endsection