@extends('redesign.layouts.listeo.front')

@section('title', 'Mein Profil')

@section('body-class', 'front page-profile')

@section('scripts-page')
    <script src="{{ asset('js/plugins/zxcvbn/zxcvbn.js') }}"></script>
    @if (!$user->paypal)
        @include('redesign.front.pieces.paypal_scripts')
    @endif
    <script src="{{ asset('listeo/scripts/profile.js') }}"></script>
@endsection

@section('styles-page')
    <link href="{{ asset('css/flags16.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Mein Profil</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Mein Profil'])
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h3 class="listing-desc-headline margin-top-0 margin-bottom-30">Persönliche Daten</h3>
            </div>
            <a name="private"></a>

            <div class="col-lg-6 col-md-12">
                @include('redesign.front.user.pieces.profile.listeo.userpic', ['user' => $user])
                @include('redesign.front.user.pieces.profile.listeo.address', ['user' => $user])
            </div>
            <div class="col-lg-6 col-md-12">
                @include('redesign.front.user.pieces.profile.listeo.personal', ['user' => $user])
                @include('redesign.front.user.pieces.profile.listeo.contacts', ['user' => $user])
                @include('redesign.front.user.pieces.profile.listeo.alias', ['user' => $user])
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <h3 class="listing-desc-headline margin-top-30 margin-bottom-30">Zahlungsdaten</h3>
            </div>
            <a name="payment"></a>

            <div class="col-lg-6 col-md-12">
                @include('redesign.front.user.pieces.profile.listeo.banking', ['user' => $user])
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <h3 class="listing-desc-headline margin-top-30 margin-bottom-30">Sicherheit</h3>
            </div>
            <a name="security"></a>

            <div class="col-lg-6 col-md-12">
                @include('redesign.front.user.pieces.profile.listeo.password', ['user' => $user])
                @include('redesign.front.user.pieces.profile.listeo.active_sessions', ['user' => $user])
            </div>
            <div class="col-lg-6 col-md-12">
                @include('redesign.front.user.pieces.profile.listeo.tfa', ['user' => $user])
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <h3 class="listing-desc-headline margin-top-30 margin-bottom-30">Newsletter</h3>
            </div>
            <a name="newsletter"></a>

            <div class="col-sm-12">
                @include('redesign.front.user.pieces.profile.listeo.newsletter', ['user' => $user])
            </div>
        </div>

        <div class="row margin-top-50 margin-bottom-50">
            <a name="remove"></a>

            <div class="col-sm-12">
                @include('redesign.front.user.pieces.profile.listeo.remove', ['user' => $user])
            </div>
        </div>
    </div>
@endsection