<tr>
    <td class="align-middle d-none d-xl-table-cell">
        <a href="{{ route('seller.index', ['alias' => $transaction->coupon->template->seller->alias]) }}">
            <div class="transactionSellerLogo" style="background-image:url('{{ $transaction->coupon->template->seller->account->logo }}')"></div>
            <span>{{ $transaction->coupon->template->seller->account->company }}</span>
        </a>
    </td>
    <td class="align-middle">
        <span class="text-monospace">{{ $transaction->coupon->present()->code }}</span>
        <div class="btn btn-outline-secondary btn-round showCoupon"
             data-coupon-id="{{ $transaction->coupon->id }}"
             @if ( \App\Coupon::STATUS_PAID === $transaction->coupon->status && Auth::id() === $transaction->coupon->consumer->id )
             data-toggle="tooltip" data-placement="top" title="Müssen bewertet werden"
             @endif
        >
            @if ( \App\Coupon::STATUS_PAID === $transaction->coupon->status && Auth::id() === $transaction->coupon->consumer->id )
                <i class="fas fa-exclamation"></i>
            @else
                <i class="fas fa-question"></i>
            @endif
        </div>
    </td>
    <td class="align-middle">{{ Format::currency($transaction->amount) }}</td>
    <td class="align-middle d-md-none">{{ $transaction->present()->status_badge }}</td>
    <td class="align-middle d-none d-md-table-cell">{{ $transaction->present()->creationDate }}</td>
    <td class="align-middle d-none d-xl-table-cell">
        <div class="transactionUserPic" style="background-image:url('{{ $transaction->coupon->agent->userpic }}')"></div>
        <span>{{ $transaction->coupon->agent->fullname }}</span>
    </td>
    <td class="align-middle d-none d-lg-table-cell">
        <div class="transactionUserPic" style="background-image:url('{{ $transaction->coupon->consumer->userpic }}')"></div>
        <span>{{ $transaction->coupon->consumer->fullname }}</span>
    </td>
    <td class="align-middle d-none d-md-table-cell">
        {{ $transaction->present()->status }}
        @if ($transaction->credit_note_id)
            <a class="btn btn-outline-primary btn-round" href="{{ $transaction->getPDFLink() }}" target="_blank"><i class="far fa-file-pdf"></i></a>
        @endif
    </td>
    <td class="align-middle d-xl-none">
        <a class="btn btn-outline-primary btn-round" data-toggle="collapse" href="#details{{ $transaction->id }}" role="button" aria-expanded="false" aria-controls="details{{ $transaction->id }}">
            <i class="fas fa-file-invoice"></i>
        </a>
        <span class="text-primary show-more-label" data-toggle="collapse" href="#details{{ $transaction->id }}" aria-expanded="false" aria-controls="details{{ $transaction->id }}">Mehr</span>
    </td>
</tr>

<tr>
    <td colspan="9" class="d-xl-none p-0">
        <div class="shadow pt-2 pb-2 collapse" id="details{{ $transaction->id }}" class="transaction-details">
            <div class="row pt-2 d-md-none">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">Datum</strong>
                    {{ $transaction->present()->creationDate }}
                </div>
            </div>
            <div class="row pt-2">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">Unternehmen</strong>
                    <a href="{{ route('seller.index', ['alias' => $transaction->coupon->template->seller->alias]) }}">
                        <div class="transactionSellerLogo" style="background-image:url('{{ $transaction->coupon->template->seller->account->logo }}')"></div>
                        <span>{{ $transaction->coupon->template->seller->account->company }}</span>
                    </a>
                </div>
            </div>
            <div class="row pt-2">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">Empfehler</strong>
                    <div class="transactionUserPic" style="background-image:url('{{ $transaction->coupon->agent->userpic }}')"></div>
                    <span>{{ $transaction->coupon->agent->fullname }}</span>
                </div>
            </div>
            <div class="row pt-2 d-lg-none">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">Kunde</strong>
                    <div class="transactionUserPic" style="background-image:url('{{ $transaction->coupon->consumer->userpic }}')"></div>
                    <span>{{ $transaction->coupon->consumer->fullname }}</span>
                </div>
            </div>
            <div class="row pt-2 d-md-none">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">Status</strong>
                    {{ $transaction->present()->status }}
                    @if ($transaction->credit_note_id)
                        <a class="btn btn-outline-primary btn-round" href="{{ $transaction->getPDFLink() }}" target="_blank"><i class="far fa-file-pdf"></i></a>
                    @endif
                </div>
            </div>
        </div>
    </td>
</tr>