<div class="card card-profile shadow p-2 text-center userProfileSection">
    <div class="card-header">Persönliche Daten</div>
    <div class="card-body">
        <div class="userProfileStatic">
            <form>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">Anrede</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="salutation" value="{{ $user->salutation }}">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">Vorname</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="firstname" value="{{ $user->firstname }}">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">Nachname</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="surname" value="{{ $user->surname }}">
                    </div>
                </div>
            </form>
        </div>
        <div class="userProfileEditable">
            <form action="{{ route('api.change-personal') }}">
                <div class="form-group row">
                    <label for="userProfileSalutation" class="col-4 col-form-label text-right">Anrede</label>
                    <div class="col-8">
                        <select class="custom-select userProfileInput" id="userProfileSalutation" name="salutation">
                            <option disabled>Bitte wählen</option>
                            <option value="Herr" @if('Herr' === $user->salutation) selected @endif>Herr</option>
                            <option value="Frau" @if('Frau' === $user->salutation) selected @endif>Frau</option>
                        </select>
                    </div>
                    <p class="userProfileError text-danger" data-input="salutation"></p>
                </div>
                <div class="form-group row">
                    <label for="userProfileName" class="col-4 col-form-label text-right">Vorname</label>
                    <div class="col-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileName" name="firstname" placeholder="Vorname" value="{{ $user->firstname }}">
                    </div>
                    <p class="userProfileError text-danger" data-input="firstname"></p>
                </div>
                <div class="form-group row">
                    <label for="userProfileSurname" class="col-4 col-form-label text-right">Nachname</label>
                    <div class="col-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileSurname" name="surname" placeholder="Nachname" value="{{ $user->surname }}">
                    </div>
                    <p class="userProfileError text-danger" data-input="surname"></p>
                </div>
            </form>
        </div>
    </div>
    <div class="card-footer">
        <div class="userProfileStatic">
            <div class="btn btn-primary userProfileEditBtn" id="userProfilePasswordChangeBtn">Ändern</div>
        </div>
        <div class="userProfileEditable">
            <div class="btn btn-primary userProfileSaveBtn" id="userProfilePasswordSaveBtn">Speichern</div>
            <div class="btn btn-secondary userProfileCancelBtn" id="userProfilePasswordCancelBtn">Stornieren</div>
        </div>
    </div>
    <div class="userProfileOverlay">
        <span><i class="fas fa-spinner animate-spin"></i></span>
    </div>
</div>